/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;

/**
 * Tells the {@link WasCell} to generate a webserver plugin configuration for a {@link WasManagedApacheHttpdServer}
 */
@SuppressWarnings("serial")
public class GenerateWasWebServerPluginConfigurationStep extends WasStepBase {

	public static final String GENERATE_PLUGIN_CONFIG_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "generate-plugin-config.py";

	protected WasManagedApacheHttpdServer webserver;

	public GenerateWasWebServerPluginConfigurationStep(WasManagedApacheHttpdServer webserver) {
		super(webserver.getNode().getCell());
		this.webserver = webserver;
		this.description = "Generating plugin for webserver " + webserver + " on node " + webserver.getNode() + " on cell " + webserver.getNode().getCell();
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("cell", cell);
		context.put("node", webserver.getNode());
		context.put("webserver", webserver);
		int res = executeWsadminJythonScriptResource(ctx, context, GENERATE_PLUGIN_CONFIG_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

	public String getPluginConfigurationFilePath() {
		return cell.getWasHome() + "/config/cells/" + cell.getName() + "/nodes/" + webserver.getNode().getName() + "/servers/" + webserver.getName()
				+ "/plugin-cfg.xml";
	}

}
