/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.StepExecutionContextListener;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecution;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@ConfigurationItem(category="middleware", description="A WebSphere Application Server cell. Is a member of Host on which the deployment manager runs.", expandable=true)
public class WasCell
extends BaseConfigurationItem {
    public static final String DISABLE_DAEMON = "com.xebialabs.deployit.plugin.was.disableDaemon";
    private static final String DAEMON_STARTED = "DEPLOYIT-DAEMON-STARTED";
    private static final String DAEMON_EXIT_CODE_MARKER = "DEPLOYIT-DAEMON-EXIT-VALUE: ";
    private static final String DAEMON_END_OF_COMMAND_MARKER = "DEPLOYIT-DAEMON-END-OF-COMMAND";
    private static final String CONFIG_DIR_NAME = "config";
    private static final String PLUGIN_FILENAME = "plugin-cfg.xml";
    @ConfigurationItemProperty
    private Host host;
    @ConfigurationItemProperty(required=true, label="WebSphere name", description="Name of the WebSphere cell, e.g. MyCell, WASCell, Cell01")
    private String name;
    @ConfigurationItemProperty(required=false, label="Administrative username", description="Username which is used to login to the WebSphere Cell.")
    private String username;
    @ConfigurationItemProperty(required=false, label="Administrative password", description="Password which is used to login to the WebSphere Cell.", password=true)
    private String password;
    @ConfigurationItemProperty(required=true, label="Deployment manager profile path", description="Path of the WebSphere deployment manager profile.", size=ConfigurationItemProperty.Size.LARGE)
    private String wasHome;
    @ConfigurationItemProperty(required=true, label="WAS version", description="Version of WebSphere Application Server.")
    private WasVersion version;
    private static Logger logger = Logger.getLogger(WasCell.class);

    public String getWsadminPath() {
        String fileSep = this.host.getOperatingSystemFamily().getFileSeparator();
        return this.getWasHome() + fileSep + "bin" + fileSep + "wsadmin" + this.host.getOperatingSystemFamily().getScriptExtension();
    }

    public String getConfigDirPath() {
        String fileSep = this.host.getOperatingSystemFamily().getFileSeparator();
        return this.getWasHome() + fileSep + CONFIG_DIR_NAME;
    }

    public String getPluginFilePath() {
        String fileSep = this.host.getOperatingSystemFamily().getFileSeparator();
        return this.getConfigDirPath() + fileSep + "cells" + fileSep + PLUGIN_FILENAME;
    }

    public HostSession connectToAdminHost() {
        return this.host.getHostSession();
    }

    public int executeWsadminJythonScript(StepExecutionContext ctx, HostSession cellHostSession, String scriptPath, String ... args) {
        String disableDaemon = System.getProperty(DISABLE_DAEMON);
        if (disableDaemon == null) {
            return this.executeWsadminJythonScriptWithDaemon(ctx, cellHostSession, scriptPath, args);
        }
        return this.executeWsadminJythonScriptDirectly((CommandExecutionCallbackHandler)new StepExecutionContextCallbackHandler(ctx), cellHostSession, scriptPath, args);
    }

    public int executeWsadminJythonScriptWithDaemon(final StepExecutionContext ctx, HostSession cellHostSession, String scriptPath, String ... args) {
        try {
            CommandExecution wsadminExecution = this.getWsadminDaemonCommandExecution(ctx);
            if (wsadminExecution == null) {
                logger.warn((Object)"Cannot create wsadmin daemon session, executing script directly");
                return this.executeWsadminJythonScriptDirectly((CommandExecutionCallbackHandler)new StepExecutionContextCallbackHandler(ctx), cellHostSession, scriptPath, args);
            }
            StringBuffer invokePyContents = new StringBuffer();
            invokePyContents.append("import sys;\r\nsys.argv=[");
            boolean first = true;
            for (String arg : args) {
                if (!first) {
                    invokePyContents.append(",");
                } else {
                    first = false;
                }
                invokePyContents.append("'");
                invokePyContents.append(arg);
                invokePyContents.append("'");
            }
            invokePyContents.append("];\r\nexecfile('");
            invokePyContents.append(scriptPath);
            invokePyContents.append("')\r\n");
            HostFile invokePyFile = cellHostSession.getTempFile(FilenameUtils.getBaseName((String)scriptPath), "-invoke.py");
            HostFileUtils.putStringToHostFile((String)invokePyContents.toString(), (HostFile)invokePyFile);
            String daemonLine = "execfile('" + invokePyFile.getPath() + "')\r\n";
            OutputStream stdin = wsadminExecution.getStdin();
            stdin.write(daemonLine.getBytes());
            stdin.flush();
            BufferedReader stdout = new BufferedReader(new InputStreamReader(wsadminExecution.getStdout()));
            final BufferedReader stderr = new BufferedReader(new InputStreamReader(wsadminExecution.getStderr()));
            Thread stderrThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        String stderrLine;
                        while ((stderrLine = stderr.readLine()) != null) {
                            ctx.logError(stderrLine);
                        }
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                    }
                }
            }, "stderr printer for wsadmin daemon running on " + (Object)((Object)this));
            stderrThread.start();
            int exitCode = 0;
            while (true) {
                String stdoutLine;
                if ((stdoutLine = stdout.readLine()) == null) {
                    throw new RuntimeIOException("Cannot execute remote command \"" + scriptPath + " " + StringUtils.join((Object[])args, (char)' ') + "\" on " + this.getHost() + ": lost connection to the wsadmin daemon");
                }
                if (stdoutLine.startsWith(DAEMON_EXIT_CODE_MARKER)) {
                    try {
                        exitCode = Integer.parseInt(stdoutLine.substring(DAEMON_EXIT_CODE_MARKER.length()));
                    }
                    catch (NumberFormatException ignored) {}
                    continue;
                }
                if (stdoutLine.equals(DAEMON_END_OF_COMMAND_MARKER)) break;
                ctx.logOutput(stdoutLine);
            }
            return exitCode;
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute remote command \"" + scriptPath + " " + StringUtils.join((Object[])args, (char)' ') + "\" on " + this.getHost(), (Throwable)exc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandExecution getWsadminDaemonCommandExecution(StepExecutionContext context) {
        String key = "CELL_SESSION_" + this.getLabel();
        WsadminDaemonExecution wrappedExecution = (WsadminDaemonExecution)context.getAttribute(key);
        if (wrappedExecution == null) {
            HostSession daemonSession = this.connectToAdminHost();
            HostFile uploadedDaemon = daemonSession.copyToTemporaryFile((Resource)new ClassPathResource("com/xebialabs/deployit/plugin/was/step/daemon.py"));
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.getWsadminPath());
            if (StringUtils.isNotBlank((String)this.getUsername())) {
                cmd.add("-user");
                cmd.add(this.getUsername());
                if (!StringUtils.isEmpty((String)this.getPassword())) {
                    cmd.add("-password");
                    cmd.add(this.getPassword());
                }
            }
            cmd.add("-lang");
            cmd.add("jython");
            cmd.add("-f");
            cmd.add(uploadedDaemon.getPath());
            String[] cmdArray = cmd.toArray(new String[cmd.size()]);
            CommandExecution daemonExecution = daemonSession.startExecute(cmdArray);
            if (daemonExecution == null) {
                daemonSession.close();
                return null;
            }
            BufferedReader stdout = new BufferedReader(new InputStreamReader(daemonExecution.getStdout()));
            try {
                String stdoutLine;
                do {
                    if ((stdoutLine = stdout.readLine()) == null) {
                        throw new RuntimeIOException("Cannot start wsadmin daemon: lost connection to the wsadmin daemon");
                    }
                    context.logOutput(stdoutLine);
                } while (!stdoutLine.startsWith(DAEMON_STARTED));
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot start wsadmin daemon", (Throwable)exc);
            }
            wrappedExecution = new WsadminDaemonExecution(daemonSession, daemonExecution);
            context.setAttribute(key, (Object)wrappedExecution);
        }
        return wrappedExecution.getCommandExecution();
    }

    public int executeWsadminJythonScriptDirectly(CommandExecutionCallbackHandler handler, HostSession s, String scriptPath, String ... args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getWsadminPath());
        if (StringUtils.isNotBlank((String)this.getUsername())) {
            cmd.add("-user");
            cmd.add(this.getUsername());
            if (!StringUtils.isEmpty((String)this.getPassword())) {
                cmd.add("-password");
                cmd.add(this.getPassword());
            }
        }
        cmd.add("-lang");
        cmd.add("jython");
        cmd.add("-f");
        cmd.add(scriptPath);
        for (String arg : args) {
            cmd.add(arg);
        }
        String[] cmdArray = cmd.toArray(new String[cmd.size()]);
        return s.execute(handler, cmdArray);
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getWasHome() {
        return this.wasHome;
    }

    public void setWasHome(String wasHome) {
        this.wasHome = wasHome;
    }

    public WasVersion getVersion() {
        return this.version;
    }

    public void setVersion(WasVersion version) {
        this.version = version;
    }

    public static final class WsadminDaemonExecution
    implements StepExecutionContextListener {
        private HostSession session;
        private CommandExecution execution;

        public WsadminDaemonExecution(HostSession session, CommandExecution execution) {
            this.session = session;
            this.execution = execution;
        }

        public CommandExecution getCommandExecution() {
            return this.execution;
        }

        public void contextDestroyed() {
            OutputStream stdin = this.execution.getStdin();
            try {
                stdin.write("QUIT\r\n".getBytes());
                stdin.flush();
                this.execution.waitFor();
            }
            catch (IOException exc) {
                logger.error((Object)"Error stopping wsadmin daemon", (Throwable)exc);
            }
            catch (RuntimeException exc) {
                logger.error((Object)"Error stopping wsadmin daemon", (Throwable)exc);
            }
            this.session.close();
        }
    }
}

