/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.mapping.DeployableArtifactMapping;
import com.xebialabs.deployit.mapper.artifact.SqlScriptToDatabaseMapper;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.httpd.mapper.StaticContentToApacheHttpdServerMapper;
import com.xebialabs.deployit.plugin.apache.httpd.step.CreateApacheHttpdVirtualHostStep;
import com.xebialabs.deployit.plugin.apache.httpd.step.DestroyApacheHttpdVirtualHostStep;
import com.xebialabs.deployit.plugin.apache.httpd.step.RestartApacheHttpdServerStep;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.mapper.EarToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.EarToWasServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.WarToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WarToWasServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasDataSourceToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasDataSourceToWasServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasJndiPropertiesToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasJndiPropertiesToWasServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqQueueConnectionFactoryToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqQueueConnectionFactoryToWasServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqQueueToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqQueueToWasServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqTopicConnectionFactoryToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqTopicConnectionFactoryToWasServerMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqTopicToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqTopicToWasServerMapper;
import com.xebialabs.deployit.plugin.was.runbook.WasClusterRunBook;
import com.xebialabs.deployit.plugin.was.runbook.WasServerRunBook;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasDeploymentRunBook
extends SingleTypeHandlingRunBook<Deployment>
implements RunBook {
    public WasDeploymentRunBook() {
        super(Deployment.class);
    }

    protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
        EarToWasClusterMapper earToClusterMapper = new EarToWasClusterMapper(change);
        EarToWasServerMapper earToServerMapper = new EarToWasServerMapper(change);
        WarToWasClusterMapper warToClusterMapper = new WarToWasClusterMapper(change);
        WarToWasServerMapper warToServerMapper = new WarToWasServerMapper(change);
        StaticContentToApacheHttpdServerMapper staticContentMapper = new StaticContentToApacheHttpdServerMapper(change);
        WasDataSourceToWasClusterMapper dsToClusterMapper = new WasDataSourceToWasClusterMapper(change);
        WasDataSourceToWasServerMapper dsToServerMapper = new WasDataSourceToWasServerMapper(change);
        WasWmqQueueToWasClusterMapper qToClusterMapper = new WasWmqQueueToWasClusterMapper(change);
        WasWmqQueueToWasServerMapper qToServerMapper = new WasWmqQueueToWasServerMapper(change);
        WasWmqQueueConnectionFactoryToWasClusterMapper qcfToClusterMapper = new WasWmqQueueConnectionFactoryToWasClusterMapper(change);
        WasWmqQueueConnectionFactoryToWasServerMapper qcfToServerMapper = new WasWmqQueueConnectionFactoryToWasServerMapper(change);
        WasWmqTopicToWasClusterMapper tToClusterMapper = new WasWmqTopicToWasClusterMapper(change);
        WasWmqTopicToWasServerMapper tToServerMapper = new WasWmqTopicToWasServerMapper(change);
        WasWmqTopicConnectionFactoryToWasClusterMapper tcfToClusterMapper = new WasWmqTopicConnectionFactoryToWasClusterMapper(change);
        WasWmqTopicConnectionFactoryToWasServerMapper tcfToServerMapper = new WasWmqTopicConnectionFactoryToWasServerMapper(change);
        WasJndiPropertiesToWasClusterMapper jndiPropertiesToClusterMapper = new WasJndiPropertiesToWasClusterMapper(change);
        WasJndiPropertiesToWasServerMapper jndiPropertiesToServerMapper = new WasJndiPropertiesToWasServerMapper(change);
        if (!this.isWasDeployment(earToClusterMapper, earToServerMapper, warToClusterMapper, warToServerMapper, dsToClusterMapper, dsToServerMapper, qToClusterMapper, qToServerMapper, qcfToClusterMapper, qcfToServerMapper, tToClusterMapper, tToServerMapper, tcfToClusterMapper, tcfToServerMapper, jndiPropertiesToClusterMapper, jndiPropertiesToServerMapper)) {
            return;
        }
        HashMap<ApacheHttpdServer, Set<String>> virtualHostsPerWebServerToDestroy = new HashMap<ApacheHttpdServer, Set<String>>();
        earToClusterMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToDestroy);
        earToClusterMapper.generateDeletionSteps(steps);
        earToServerMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToDestroy);
        earToServerMapper.generateDeletionSteps(steps);
        warToClusterMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToDestroy);
        warToClusterMapper.generateDeletionSteps(steps);
        warToServerMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToDestroy);
        warToServerMapper.generateDeletionSteps(steps);
        tToClusterMapper.generateDeletionSteps(steps);
        tToServerMapper.generateDeletionSteps(steps);
        tcfToClusterMapper.generateDeletionSteps(steps);
        tcfToServerMapper.generateDeletionSteps(steps);
        qToClusterMapper.generateDeletionSteps(steps);
        qToServerMapper.generateDeletionSteps(steps);
        qcfToClusterMapper.generateDeletionSteps(steps);
        qcfToServerMapper.generateDeletionSteps(steps);
        dsToClusterMapper.generateDeletionSteps(steps);
        dsToServerMapper.generateDeletionSteps(steps);
        jndiPropertiesToClusterMapper.generateDeletionSteps(steps);
        jndiPropertiesToServerMapper.generateDeletionSteps(steps);
        if (change.isModification()) {
            WasClusterRunBook wasClusterRunBook = new WasClusterRunBook();
            Set<Change<WasCluster>> clusterChanges = this.findClusterChangesForDeploymentChange(change, changePlan);
            for (Change<WasCluster> eachClusterChange : clusterChanges) {
                wasClusterRunBook.getStepsForModifiedCluster(steps, (WasCluster)((Object)eachClusterChange.getOldRevision()), (WasCluster)((Object)eachClusterChange.getNewRevision()));
            }
            WasServerRunBook wasServerRunBook = new WasServerRunBook();
            Set<Change<WasServer>> serverChanges = this.findServerChangesForDeploymentChange(change, changePlan);
            for (Change<WasServer> eachServerChange : serverChanges) {
                wasServerRunBook.getStepsForModifiedServer(steps, (WasServer)((Object)eachServerChange.getOldRevision()), (WasServer)((Object)eachServerChange.getNewRevision()));
            }
        }
        SqlScriptToDatabaseMapper sqlMapper = new SqlScriptToDatabaseMapper(change);
        sqlMapper.generateAdditionSteps(steps);
        HashMap<ApacheHttpdServer, Set<String>> virtualHostsPerWebServerToCreate = new HashMap<ApacheHttpdServer, Set<String>>();
        jndiPropertiesToClusterMapper.generateAdditionSteps(steps);
        jndiPropertiesToServerMapper.generateAdditionSteps(steps);
        dsToClusterMapper.generateAdditionSteps(steps);
        dsToServerMapper.generateAdditionSteps(steps);
        qcfToClusterMapper.generateAdditionSteps(steps);
        qcfToServerMapper.generateAdditionSteps(steps);
        qToClusterMapper.generateAdditionSteps(steps);
        qToServerMapper.generateAdditionSteps(steps);
        tcfToClusterMapper.generateAdditionSteps(steps);
        tcfToServerMapper.generateAdditionSteps(steps);
        tToClusterMapper.generateAdditionSteps(steps);
        tToServerMapper.generateAdditionSteps(steps);
        warToClusterMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        warToClusterMapper.generateAdditionSteps(steps);
        warToServerMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        warToServerMapper.generateAdditionSteps(steps);
        earToClusterMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        earToClusterMapper.generateAdditionSteps(steps);
        earToServerMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        earToServerMapper.generateAdditionSteps(steps);
        staticContentMapper.generateDeletionSteps(steps);
        this.destroyApacheVirtualHosts(virtualHostsPerWebServerToDestroy, steps);
        this.restartApacheWebServers(virtualHostsPerWebServerToDestroy, steps);
        this.createApacheVirtualHosts(virtualHostsPerWebServerToCreate, steps);
        staticContentMapper.generateAdditionSteps(steps);
        this.restartApacheWebServers(virtualHostsPerWebServerToCreate, steps);
    }

    private boolean isWasDeployment(EarToWasClusterMapper earToClusterMapper, EarToWasServerMapper earToServerMapper, WarToWasClusterMapper warMapper, WarToWasServerMapper warToServerMapper, WasDataSourceToWasClusterMapper dsToClusterMapper, WasDataSourceToWasServerMapper dsToServerMapper, WasWmqQueueToWasClusterMapper qToClusterMapper, WasWmqQueueToWasServerMapper qToServerMapper, WasWmqQueueConnectionFactoryToWasClusterMapper qcfToClusterMapper, WasWmqQueueConnectionFactoryToWasServerMapper qcfToServerMapper, WasWmqTopicToWasClusterMapper tToClusterMapper, WasWmqTopicToWasServerMapper tToServerMapper, WasWmqTopicConnectionFactoryToWasClusterMapper tcfToClusterMapper, WasWmqTopicConnectionFactoryToWasServerMapper tcfToServerMapper, WasJndiPropertiesToWasClusterMapper jndiPropertiesToClusterMapper, WasJndiPropertiesToWasServerMapper jndiPropertiesToServerMapper) {
        HashSet affectedClusters = new HashSet();
        affectedClusters.addAll(earToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(warMapper.getAffectedTargets());
        affectedClusters.addAll(dsToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(qToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(qcfToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(tToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(tcfToClusterMapper.getAffectedTargets());
        affectedClusters.addAll(jndiPropertiesToClusterMapper.getAffectedTargets());
        HashSet affectedServers = new HashSet();
        affectedServers.addAll(earToServerMapper.getAffectedTargets());
        affectedServers.addAll(warToServerMapper.getAffectedTargets());
        affectedServers.addAll(dsToServerMapper.getAffectedTargets());
        affectedServers.addAll(qToServerMapper.getAffectedTargets());
        affectedServers.addAll(tToServerMapper.getAffectedTargets());
        affectedServers.addAll(qcfToServerMapper.getAffectedTargets());
        affectedServers.addAll(tcfToServerMapper.getAffectedTargets());
        affectedServers.addAll(jndiPropertiesToServerMapper.getAffectedTargets());
        return !affectedClusters.isEmpty() || !affectedServers.isEmpty();
    }

    private Set<Change<WasCluster>> findClusterChangesForDeploymentChange(Change<Deployment> deploymentChange, ChangePlan changePlan) {
        HashSet<Change<WasCluster>> clusterChanges = new HashSet<Change<WasCluster>>();
        for (Change change : changePlan.getChanges()) {
            Change clusterChange;
            if (!change.isModification() || change.getConfigurationItemClass() != WasCluster.class || !this.isClusterDeploymentTarget((WasCluster)((Object)(clusterChange = change).getOldRevision()), (Deployment)deploymentChange.getOldRevision()) || !this.isClusterDeploymentTarget((WasCluster)((Object)clusterChange.getNewRevision()), (Deployment)deploymentChange.getNewRevision())) continue;
            clusterChanges.add((Change<WasCluster>)clusterChange);
        }
        return clusterChanges;
    }

    private Set<Change<WasServer>> findServerChangesForDeploymentChange(Change<Deployment> deploymentChange, ChangePlan changePlan) {
        HashSet<Change<WasServer>> serverChanges = new HashSet<Change<WasServer>>();
        for (Change change : changePlan.getChanges()) {
            Change serverChange;
            if (!change.isModification() || change.getConfigurationItemClass() != WasServer.class || !this.isServerDeploymentTarget((WasServer)((Object)(serverChange = change).getOldRevision()), (Deployment)deploymentChange.getOldRevision()) || !this.isServerDeploymentTarget((WasServer)((Object)serverChange.getNewRevision()), (Deployment)deploymentChange.getNewRevision())) continue;
            serverChanges.add((Change<WasServer>)serverChange);
        }
        return serverChanges;
    }

    private boolean isClusterDeploymentTarget(WasCluster cluster, Deployment deployment) {
        List deployableArtifactMappings = deployment.getMappingsOfType(DeployableArtifactMapping.class);
        for (DeployableArtifactMapping eachMapping : deployableArtifactMappings) {
            if (!eachMapping.getTarget().equals((Object)cluster)) continue;
            return true;
        }
        return false;
    }

    private boolean isServerDeploymentTarget(WasServer server, Deployment deployment) {
        List deployableArtifactMappings = deployment.getMappingsOfType(DeployableArtifactMapping.class);
        for (DeployableArtifactMapping eachMapping : deployableArtifactMappings) {
            if (!eachMapping.getTarget().equals((Object)server)) continue;
            return true;
        }
        return false;
    }

    private void createApacheVirtualHosts(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer, List<Step> steps) {
        for (Map.Entry<ApacheHttpdServer, Set<String>> eachVirtualHostPerWebServer : virtualHostsPerWebServer.entrySet()) {
            ApacheHttpdServer eachWebServer = eachVirtualHostPerWebServer.getKey();
            for (String eachVirtualHost : eachVirtualHostPerWebServer.getValue()) {
                steps.add((Step)new CreateApacheHttpdVirtualHostStep(eachWebServer, eachVirtualHost, Collections.singletonList(eachWebServer)));
            }
        }
    }

    private void destroyApacheVirtualHosts(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer, List<Step> steps) {
        for (Map.Entry<ApacheHttpdServer, Set<String>> eachVirtualHostPerWebServer : virtualHostsPerWebServer.entrySet()) {
            ApacheHttpdServer eachWebServer = eachVirtualHostPerWebServer.getKey();
            for (String eachVirtualHost : eachVirtualHostPerWebServer.getValue()) {
                steps.add((Step)new DestroyApacheHttpdVirtualHostStep(eachWebServer, eachVirtualHost));
            }
        }
    }

    private void restartApacheWebServers(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer, List<Step> steps) {
        for (ApacheHttpdServer eachWebServer : virtualHostsPerWebServer.keySet()) {
            steps.add((Step)new RestartApacheHttpdServerStep(eachWebServer));
        }
    }
}

