/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.step.CreateWasServerStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasServerStep;
import com.xebialabs.deployit.plugin.was.step.ModifyWasServerStep;
import com.xebialabs.deployit.plugin.was.step.StartWasServerStep;
import com.xebialabs.deployit.plugin.was.step.StopWasServerStep;
import com.xebialabs.deployit.plugin.was.step.SynchronizeWasNodeStep;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasServerRunBook
extends SingleTypeHandlingRunBook<WasServer>
implements RunBook {
    public WasServerRunBook() {
        super(WasServer.class);
    }

    public void resolve(Change<WasServer> change, ChangePlan changePlan, List<Step> steps) {
        WasServer newServer;
        WasServer oldServer = (WasServer)((Object)change.getOldRevision());
        boolean identical = ConfigurationItemReflectionUtils.isIdentical((Serializable)((Object)oldServer), (Serializable)((Object)(newServer = (WasServer)((Object)change.getNewRevision()))));
        if (!identical) {
            if (change.isModification() && !this.modificationWillBeHandledByWasDeploymentRunBook(change, changePlan)) {
                this.getStepsForModifiedServer(steps, oldServer, newServer);
            }
            if (change.isDeletion()) {
                steps.add(new StopWasServerStep(oldServer, false));
                steps.add(new DestroyWasServerStep(oldServer));
                steps.add(new SynchronizeWasNodeStep(oldServer.getNode()));
            }
            if (change.isAddition()) {
                steps.add(new CreateWasServerStep(newServer));
                steps.add(new ModifyWasServerStep(newServer));
                steps.add(new SynchronizeWasNodeStep(newServer.getNode()));
                steps.add(new StartWasServerStep(newServer));
            }
        }
    }

    public void getStepsForModifiedServer(List<Step> steps, WasServer oldServer, WasServer newServer) {
        steps.add(new StopWasServerStep(oldServer, false));
        steps.add(new ModifyWasServerStep(newServer));
        steps.add(new StartWasServerStep(newServer));
    }

    private boolean modificationWillBeHandledByWasDeploymentRunBook(Change<WasServer> serverChange, ChangePlan changePlan) {
        Change<Deployment> deploymentChange = this.findChangeForModifiedDeploymentOfModifiedServer(serverChange, changePlan);
        return deploymentChange != null;
    }

    private Change<Deployment> findChangeForModifiedDeploymentOfModifiedServer(Change<WasServer> serverChange, ChangePlan changePlan) {
        if (!serverChange.isModification()) {
            return null;
        }
        for (Change change : changePlan.getChanges()) {
            if (!change.isModification() || change.getConfigurationItemClass() != Deployment.class) continue;
            WasServer oldServer = (WasServer)((Object)serverChange.getOldRevision());
            WasServer newServer = (WasServer)((Object)serverChange.getNewRevision());
            Deployment oldDeployment = (Deployment)change.getOldRevision();
            Deployment newDeployment = (Deployment)change.getNewRevision();
            boolean oldServerWasTarget = oldDeployment.getTarget().getMembersOfType(WasServer.class).contains((Object)oldServer);
            boolean newServerWasTarget = newDeployment.getTarget().getMembersOfType(WasServer.class).contains((Object)newServer);
            if (!oldServerWasTarget || !newServerWasTarget) continue;
            return change;
        }
        return null;
    }
}

