/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;

public class AddSingleWasClusterMemberStep
extends WasStepBase {
    protected static final String CLONE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/clone-cluster-member.py";
    protected WasCluster cluster;
    protected WasNode node;
    private int cloneNumber;

    public AddSingleWasClusterMemberStep(WasCluster cluster, WasNode node, int cloneNumber) {
        super(cluster.getCell());
        this.cloneNumber = cloneNumber;
        this.cluster = cluster;
        this.node = node;
        this.setDescription("Add a member (clone) " + cloneNumber + " for cluster \"" + cluster.getLabel() + "\" on node \"" + node.getLabel() + "\" in cell \"" + this.cell.getLabel() + "\"");
    }

    public boolean execute(StepExecutionContext ctx) {
        String clusterMemberNamesPrefix = this.cluster.getMemberNamePrefix(this.node.getName());
        String startOfBootstrapPortNumberRange = Integer.toString(this.cluster.getStartOfBootstrapPortNumberRange());
        String startOfSoapConnectorPortNumberRange = Integer.toString(this.cluster.getStartOfSoapConnectorPortNumberRange());
        return this.executeWsadminJythonScriptResource(ctx, CLONE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH, this.node.getName(), this.cluster.getName(), clusterMemberNamesPrefix, Integer.toString(this.cloneNumber), startOfBootstrapPortNumberRange, "BOOTSTRAP_ADDRESS", startOfSoapConnectorPortNumberRange, "SOAP_CONNECTOR_ADDRESS") == 0;
    }
}

