/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ControlApplicationStep
extends WasStepBase {
    protected static final String CONTROL_APPLICATION_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/control-application.py";
    protected WasCluster cluster;
    protected NamedDeployableArtifact application;
    protected String applicationManagerCommand;
    protected List<String> applicationManagerObjectNames;

    protected ControlApplicationStep(WasCluster cluster, NamedDeployableArtifact application, String applicationManagerCommand, String descriptionPrefix) {
        super(cluster.getCell());
        this.cluster = cluster;
        this.application = application;
        this.applicationManagerCommand = applicationManagerCommand;
        Map<WasNode, List<String>> serverNamesPerNode = cluster.getServerNamesPerNode();
        this.applicationManagerObjectNames = new ArrayList<String>();
        for (Map.Entry<WasNode, List<String>> each : serverNamesPerNode.entrySet()) {
            WasNode eachNode = each.getKey();
            List<String> eachNodeServerNames = each.getValue();
            for (String eachServerName : eachNodeServerNames) {
                this.applicationManagerObjectNames.add("cell=" + this.cell.getName() + ",node=" + eachNode.getName() + ",type=ApplicationManager,process=" + eachServerName + ",*");
            }
        }
        this.setDescription(descriptionPrefix + " " + ExtendedStringUtils.getQuotedString((String)application.getLabel()) + " on cluster " + ExtendedStringUtils.getQuotedString((String)cluster.getLabel()) + " in cell " + ExtendedStringUtils.getQuotedString((String)this.cell.getLabel()));
    }

    protected ControlApplicationStep(WasServer server, NamedDeployableArtifact application, String applicationManagerCommand, String descriptionPrefix) {
        super(server.getNode().getCell());
        this.application = application;
        this.applicationManagerCommand = applicationManagerCommand;
        this.applicationManagerObjectNames = new ArrayList<String>();
        this.applicationManagerObjectNames.add("cell=" + this.cell.getName() + ",node=" + server.getNode().getName() + ",type=ApplicationManager,process=" + server.getName() + ",*");
        this.setDescription(descriptionPrefix + " " + ExtendedStringUtils.getQuotedString((String)application.getLabel()) + " on server " + ExtendedStringUtils.getQuotedString((String)server.getLabel()) + " in cell " + ExtendedStringUtils.getQuotedString((String)this.cell.getLabel()));
    }

    public boolean execute(StepExecutionContext ctx) {
        String[] args = new String[2 + this.applicationManagerObjectNames.size()];
        args[0] = this.application.getName();
        args[1] = this.applicationManagerCommand;
        for (int i = 0; i < this.applicationManagerObjectNames.size(); ++i) {
            args[i + 2] = this.applicationManagerObjectNames.get(i);
        }
        return this.executeWsadminJythonScriptResource(ctx, CONTROL_APPLICATION_SCRIPT_RESOURCE_PATH, args) == 0;
    }
}

