/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasDataSource;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.util.ExtendedStringUtils;

public class DestroyWasDataSourceStep
extends WasStepBase {
    public static final String DESTROY_DATASOURCE_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/destroy-datasource.py";
    public static final String DESTROY_DATASOURCE_ON_SERVER_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/destroy-datasource-on-server.py";
    private WasDataSource wasDataSource;
    private WasCluster cluster;
    private WasServer server;

    public DestroyWasDataSourceStep(WasDataSource wasDataSource, WasCluster cluster) {
        super(cluster.getCell());
        this.wasDataSource = wasDataSource;
        this.cluster = cluster;
        this.server = null;
        this.setDescription("Destroy datasource " + ExtendedStringUtils.getQuotedString((String)wasDataSource.getLabel()) + " in cell " + ExtendedStringUtils.getQuotedString((String)cluster.getCell().getLabel()) + " for cluster " + ExtendedStringUtils.getQuotedString((String)cluster.getLabel()));
    }

    public DestroyWasDataSourceStep(WasDataSource wasDataSource, WasServer server) {
        super(server.getNode().getCell());
        this.wasDataSource = wasDataSource;
        this.cluster = null;
        this.server = server;
        this.setDescription("Destroy datasource " + ExtendedStringUtils.getQuotedString((String)wasDataSource.getLabel()) + " in node " + ExtendedStringUtils.getQuotedString((String)server.getNode().getLabel()) + " for server " + ExtendedStringUtils.getQuotedString((String)server.getLabel()));
    }

    public boolean execute(StepExecutionContext ctx) {
        if (this.cluster != null && this.server == null) {
            return this.executeWsadminJythonScriptResource(ctx, DESTROY_DATASOURCE_SCRIPT_RESOURCE_PATH, this.wasDataSource.getName(), this.wasDataSource.getProvider(), this.cell.getName(), this.cluster.getName()) == 0;
        }
        if (this.cluster == null && this.server != null) {
            return this.executeWsadminJythonScriptResource(ctx, DESTROY_DATASOURCE_ON_SERVER_SCRIPT_RESOURCE_PATH, this.wasDataSource.getName(), this.wasDataSource.getProvider(), this.cell.getName(), this.server.getNode().getName(), this.server.getName()) == 0;
        }
        return false;
    }
}

