/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.util.ExtendedStringUtils;

public class StartWasSingleClusterMemberStep
extends WasStepBase {
    protected static final String START_SINGLE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/start-single-cluster-member.py";
    protected WasCluster cluster;
    protected WasNode node;
    private int cloneNumber;

    public StartWasSingleClusterMemberStep(WasCluster cluster, WasNode node, int cloneNumber) {
        super(cluster.getCell());
        this.cluster = cluster;
        this.node = node;
        this.cloneNumber = cloneNumber;
        this.setDescription("Start members of cluster " + ExtendedStringUtils.getQuotedString((String)cluster.getLabel()) + " on node " + ExtendedStringUtils.getQuotedString((String)node.getLabel()) + " in cell " + ExtendedStringUtils.getQuotedString((String)this.cell.getLabel()));
    }

    public boolean execute(StepExecutionContext ctx) {
        String clusterMemberNamesPrefix = this.cluster.getMemberNamePrefix(this.node.getName());
        String clusterMemberNumber = Integer.toString(this.cloneNumber);
        return this.executeWsadminJythonScriptResource(ctx, START_SINGLE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH, this.node.getName(), clusterMemberNamesPrefix, clusterMemberNumber) == 0;
    }
}

