package com.xebialabs.deployit.plugin.was.ci;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "A WebSphere cluster. Is a member of the WebSphereCell to which it belongs.", targetForMappingTypes = { EarMapping.class })
public class WasCluster extends BaseConfigurationItem {


	@ConfigurationItemProperty(required = true, label = "WebSphere administrative cell")
	private WasCell cell;

	@ConfigurationItemProperty
	private Set<WasNode> nodes;

	@ConfigurationItemProperty(required = true, label = "WebSphere name", description = "Name of the WebSphere cluster, e.g. cluster1")
	private String name;

	@ConfigurationItemProperty(required = true, label = "# of cluster members", description = "Number of members (servers participating in this cluster) per WebSphere node, change this field to add or remove members (#servers).")
	private int numberOfClusterMembers;

	@ConfigurationItemProperty(required = false, label = "Start of bootstrap port # range", description = "The first portNumber to be assigned to the BOOTSTRAP_ADDRESS of servers in this cluster. If this field is empty, WebSphere will select this value.")
	private int startOfBootstrapPortNumberRange;

	@ConfigurationItemProperty(required = false, label = "Start of SOAP connector port # range", description = "The first portNumber to be assigned to the SOAP_CONNECTOR_ADDRESS of servers in this cluster. If this field is empty, WebSphere will select this value.")
	private int startOfSoapConnectorPortNumberRange;

	@ConfigurationItemProperty(required = false, label = "Classpath", description = "Classpath for this cluster.", category = "JVM")
	private String classpath;

	@ConfigurationItemProperty(required = false, label = "Boot classpath", description = "Boot classpath for this cluster.", category = "JVM")
	private String bootClasspath;

	@ConfigurationItemProperty(required = false, label = "Initial heap size", description = "Initial heap size to be allocated to the JVM (in megabytes).", category = "JVM")
	private int initHeapSize;

	@ConfigurationItemProperty(required = false, label = "Maximum heap size", description = "Maximum heap size to be allocated to the JVM (in megabytes).", category = "JVM")
	private int maxHeapSize;

	@ConfigurationItemProperty(required = false, label = "JVM arguments", description = "Generic JVM arguments.", category = "JVM")
	private String jvmArguments;

	@ConfigurationItemProperty(required = false, label = "Disable JIT", description = "Disable just-in-time compiler.", category = "JVM")
	private boolean disableJit;

	@ConfigurationItemProperty(required = false, label = "Classloader policy and mode", description = "Server-wide application classloader policy and mode", category = "JVM")
	private WasClassLoaderPolicyAndMode applicationClassLoaderPolicyAndMode;

	@ConfigurationItemProperty(required = false, label = "Working directory", description = "Working directory of started process.", category = "JVM")
	private String workingDir;

	@ConfigurationItemProperty(required = false, label = "Unix umask", description = "Umask of started process.", category = "JVM")
	private String umask;

	@ConfigurationItemProperty(required = false, label = "Stdout logfile prefix", description = "Prefix of the path to the stdout log file. Example; /data/waslogs/stdout_", category = "Logging")
	private String stdOut;

	@ConfigurationItemProperty(required = false, label = "Stderr logfile prefix", description = "Prefix of the path to the stderr log file. Example; /data/waslogs/stderr_", category = "Logging")
	private String stdErr;

	@ConfigurationItemProperty(required = false, label = "JVM stdout logfile prefix", description = "Prefix of the path to the JVM stdout log file. Example; /data/waslogs/jvmstdout_", category = "Logging")
	private String jvmStdOut;

	@ConfigurationItemProperty(required = false, label = "JVM stderr logfile prefix", description = "Prefix of the path to the JVM stderr log file. Example; /data/waslogs/jvmstderr_", category = "Logging")
	private String jvmStdErr;

	@ConfigurationItemProperty(required = false, label = "Enable Servlet caching", category = "Web container")
	private boolean servletCaching = false;

	@ConfigurationItemProperty(required = false, label = "Session timeout", description = "Session timeout in minutes", category = "Web container")
	private int sessionTimeout = 30;

	@ConfigurationItemProperty(required = false, label = "Max # of session in memory", description = "Maximum # of session in memory", category = "Web container")
	private int maximumSessionsInMemory = 1000;

	@ConfigurationItemProperty(required = false, label = "Enable session cookies", category = "Web container")
	private boolean enableSessionCookies = false;

	@ConfigurationItemProperty(required = false, label = "Session cookie name", category = "Web container")
	private String cookieName = null;

	@ConfigurationItemProperty(required = false, label = "Session cookie domain", category = "Web container")
	private String cookieDomain = null;

	@ConfigurationItemProperty(required = false, label = "Session cookie path", category = "Web container")
	private String cookiePath = null;

	public WasCell getCell() {
		return cell;
	}

	public void setCell(WasCell cell) {
		this.cell = cell;
	}

	public Set<WasNode> getNodes() {
		return nodes;
	}

	public void setNodes(Set<WasNode> nodes) {
		this.nodes = nodes;
	}

	public static String getLogPathForMember(String memberServerName, String logPrefix) {
		if (StringUtils.isBlank(logPrefix)) {
			return logPrefix;
		} else {
			return logPrefix + memberServerName + ".txt";
		}
	}

	public Map<WasNode, List<String>> getServerNamesPerNode() {
		Map<WasNode, List<String>> res = new HashMap<WasNode, List<String>>();
		for (WasNode eachNode : getNodes()) {
			String prefix = getMemberNamePrefix(eachNode.getName());
			List<String> serverNames = new ArrayList<String>();
			for (int i = 1; i <= getNumberOfClusterMembers(); i++) {
				serverNames.add(prefix + Integer.toString(i));
			}
			res.put(eachNode, serverNames);
		}
		return res;
	}

	public String getMemberNamePrefix(String nodeName) {
		// clustername_nodename_Clone<number>
		return stripCluster(getName()) + WasNaming.SEPARATOR + nodeName + WasNaming.SEPARATOR + WasNaming.CLONE;
	}

	private static String stripCluster(String clusterName) {
		return (clusterName.endsWith("_Cluster") 
		        ? clusterName.substring(0, clusterName.length() - 8)
		        : clusterName);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getNumberOfClusterMembers() {
		return numberOfClusterMembers;
	}

	public void setNumberOfClusterMembers(int numberOfClusterMembers) {
		this.numberOfClusterMembers = numberOfClusterMembers;
	}

	public int getStartOfBootstrapPortNumberRange() {
		return startOfBootstrapPortNumberRange;
	}

	public void setStartOfBootstrapPortNumberRange(int startOfBootstrapPortNumberRange) {
		this.startOfBootstrapPortNumberRange = startOfBootstrapPortNumberRange;
	}

	public int getStartOfSoapConnectorPortNumberRange() {
		return startOfSoapConnectorPortNumberRange;
	}

	public void setStartOfSoapConnectorPortNumberRange(int startOfSoapConnectorPortNumberRange) {
		this.startOfSoapConnectorPortNumberRange = startOfSoapConnectorPortNumberRange;
	}

	public boolean getServletCaching() {
		return servletCaching;
	}

	public void setServletCaching(boolean servletCaching) {
		this.servletCaching = servletCaching;
	}

	public int getSessionTimeout() {
		return sessionTimeout;
	}

	public void setSessionTimeout(int sessionTimeout) {
		this.sessionTimeout = sessionTimeout;
	}

	public int getMaximumSessionsInMemory() {
		return maximumSessionsInMemory;
	}

	public void setMaximumSessionsInMemory(int maximumSessionsInMemory) {
		this.maximumSessionsInMemory = maximumSessionsInMemory;
	}

	public boolean getEnableSessionCookies() {
		return enableSessionCookies;
	}

	public void setEnableSessionCookies(boolean enableCookies) {
		this.enableSessionCookies = enableCookies;
	}

	public String getCookieName() {
		return cookieName;
	}

	public void setCookieName(String cookieName) {
		this.cookieName = cookieName;
	}

	public String getCookieDomain() {
		return cookieDomain;
	}

	public void setCookieDomain(String cookieDomain) {
		this.cookieDomain = cookieDomain;
	}

	public String getCookiePath() {
		return cookiePath;
	}

	public void setCookiePath(String cookiePath) {
		this.cookiePath = cookiePath;
	}

	public String getClasspath() {
		return classpath;
	}

	public void setClasspath(String classpath) {
		this.classpath = classpath;
	}

	public String getBootClasspath() {
		return bootClasspath;
	}

	public void setBootClasspath(String bootClasspath) {
		this.bootClasspath = bootClasspath;
	}

	public int getInitHeapSize() {
		return initHeapSize;
	}

	public void setInitHeapSize(int initHeapSize) {
		this.initHeapSize = initHeapSize;
	}

	public int getMaxHeapSize() {
		return maxHeapSize;
	}

	public void setMaxHeapSize(int maxHeapSize) {
		this.maxHeapSize = maxHeapSize;
	}

	public String getStdOut() {
		return stdOut;
	}

	public void setStdOut(String stdOut) {
		this.stdOut = stdOut;
	}

	public String getStdErr() {
		return stdErr;
	}

	public void setStdErr(String stdErr) {
		this.stdErr = stdErr;
	}

	public String getJvmStdOut() {
		return jvmStdOut;
	}

	public void setJvmStdOut(String jvmStdOut) {
		this.jvmStdOut = jvmStdOut;
	}

	public String getJvmStdErr() {
		return jvmStdErr;
	}

	public void setJvmStdErr(String jvmStdErr) {
		this.jvmStdErr = jvmStdErr;
	}

	public WasClassLoaderPolicyAndMode getApplicationClassLoaderPolicyAndMode() {
		return applicationClassLoaderPolicyAndMode;
	}

	public void setApplicationClassLoaderPolicyAndMode(WasClassLoaderPolicyAndMode applicationClassLoaderPolicyAndMode) {
		this.applicationClassLoaderPolicyAndMode = applicationClassLoaderPolicyAndMode;
	}

	public String getJvmArguments() {
		return jvmArguments;
	}

	public void setJvmArguments(String jvmArguments) {
		this.jvmArguments = jvmArguments;
	}

	public boolean getDisableJit() {
		return disableJit;
	}

	public void setDisableJit(boolean disableJit) {
		this.disableJit = disableJit;
	}

	public String getWorkingDir() {
		return workingDir;
	}

	public void setWorkingDir(String workingDir) {
		this.workingDir = workingDir;
	}

	public String getUmask() {
		return umask;
	}

	public void setUmask(String umask) {
		this.umask = umask;
	}

	public static String getMemberNamesPrefix(String clusterName, String nodeName) {
		return clusterName + "_" + nodeName + "_Clone";
	}

}
