package com.xebialabs.deployit.plugin.was.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;

public class WarToWasClusterMapper extends JeeArtifactToWasClusterMapper<War, WarMapping> {

	public WarToWasClusterMapper(Change<Deployment> change) {
		super(change, false);
	}

	@Override
	protected void generateDeployStep(War artifact, WarMapping mapping, WasCluster cluster, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps) {
		steps.add(new WasDeployApplicationStep(cluster.getCell(), artifact, Collections.singleton(cluster), webservers, mapping.getVirtualHost(), mapping
				.getContextRoot()));
	}

	@Override
	protected void generateUndeployStep(War artifact, WasCluster cluster, List<Step> steps) {
		steps.add(new WasUndeployApplicationStep(cluster.getCell(), artifact));
	}

	@Override
	protected void generateStartStep(War artifact, WasCluster cluster, List<Step> steps) {
		steps.add(new WasStartApplicationStep(cluster, artifact));
	}

	@Override
	protected void generateStopStep(War artifact, WasCluster cluster, List<Step> steps) {
		steps.add(new WasStopApplicationStep(cluster, artifact));
	}

	@Override
	protected String getVirtualHostFromMapping(WarMapping mapping) {
		return mapping.getVirtualHost();
	}

}
