package com.xebialabs.deployit.plugin.was.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasWmqQueue;
import com.xebialabs.deployit.plugin.was.step.CreateWasWmqQueueStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasWmqQueueStep;

public class WasWmqQueueToWasClusterMapper extends MappingAgnosticStepGeneratingMapper<WasWmqQueue, WasCluster> {

	public WasWmqQueueToWasClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WasWmqQueue resource, WasCluster cluster, List<Step> steps) {
		steps.add(new CreateWasWmqQueueStep(cluster, resource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WasWmqQueue resource, WasCluster cluster, List<Step> steps) {
		steps.add(new DestroyWasWmqQueueStep(cluster, resource));
	}

}
