/**
 * <h2>The <a href="http://www.xebialabs.com/deployit-automated-deployment-java-applications">Deployit</a> plugin for WebSphere Application Server.</h2>
 * 
 * This is the standard Deployit plugin for functionality related to IBM WebSphere Application
 * Server (further referenced in this documentation as WAS), optionally in combination with 
 * <a href="http://httpd.apache.org">Apache web servers >= 2.x</a>. It provides support 
 * for WAS-specific components and allows users to deploy applications containing 
 * WebSphere resources to a WAS Network Deployment environment.
 * 
 * <h3>Supported middleware</h3>
 * 
 * This plugin supports WebSphere Application Server (WAS) versions 6.1 to 7.0 in a 
 * <a href="http://www-01.ibm.com/software/webservers/appserv/was/network/">Network Deployment Configuration</a>.
 * 
 * <h3>Requirements</h3>
 * 
 * The plugin executes its deployment and configuration tasks by connecting to the
 * target host systems and executing WSADMIN commands there. This implies that the following
 * must be possible:
 * 
 * <ul>
 * <li>creating a connection to the host on which the "deployment manager" is running, 
 * using the {@link com.xebialabs.deployit.ci.Host Host's} specified connection methods
 * <li>starting [WAS_PROFILE_ROOT]/[DMGR_PROFILE]/bin/wsadmin.sh (or on Windows wsadmin.bat) on the target host server 
 * under the user Deployit uses to connect to the host (or the SUDO user, if specified)
 * </ul>
 * 
 * In addition, if the plugin is being used in an Apache/WAS environment in order to configure the
 * Apache WebSphere plugin:
 * 
 * <ul>
 * <li>the Apache server must have the correct version of the WAS plugin installed
 * and activated (see <a href="http://publib.boulder.ibm.com/infocenter/dmndhelp/v6rxmx/index.jsp?topic=/com.ibm.websphere.nd.doc/info/ae/ae/tins_manualWebApache20.html">IBM reference documentation</a>)
 * <li>Apache must be configured to include all {@code *.conf} files in a certain directory
 * in its configuration
 * <li>it must be possible to create a connection from the Deployit server to the Apache
 * server(s) being administered
 * <li>the user under which Deployit connects to the Apache servers (or the SUDO user, if
 * specified) must be able to create, modify and delete files in the Apache configuration
 * directory referred to above
 * <li>this user must also be able to stop, start and restart Apache (uses apachectl)
 * </ul>
 * 
 * If Deployit is intended to be used to manage existing {@link com.xebialabs.deployit.plugin.was.ci.WasCluster
 * WAS Clusters} (i.e. ones not created by Deployit), the clusters' servers must be named
 * according to the convention <code><em>clustername</em>_<em>nodename</em>_Clone<em>index</em></code>,
 * e.g. {@code was-cluster_was-node_Clone2}.
 *  
 * <h3>Components</h3>
 * 
 * WAS middleware environments are modelled on the basis of the following Configuration
 * Items (CIs):
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasCell WAS Cell}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasNode WAS Node}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasCluster WAS Cluster}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer WAS Managed Apache WebServer}
 * </ul>
 * 
 * Further, the plugin provides CIs for the following WAS-related resources:
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasDataSource JDBC DataSource}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasWmqQueueConnectionFactory JMS WebSphere MQSeries Queue Connection Factory}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasWmqTopicConnectionFactory JMS WebSphere MQSeries Topic Connection Factory}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasWmqQueue JMS WebSphere MQSeries Queue}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasWmqTopic JMS WebSphere MQSeries Topic}
 * </ul>
 * 
 * <h3>Supported scenarios</h3>
 * 
 * The plugin supports:
 * 
 * <ul>
 * <li>the initial deployment, re- and undeployment of deployment packages to/from WAS environments
 * via the {@link com.xebialabs.deployit.plugin.was.runbook.WasDeploymentRunBook WAS Deployment RunBook}
 * <li>the creating and deletion of Clusters and modification of their settings via
 * the {@link com.xebialabs.deployit.plugin.was.runbook.WasClusterRunBook WAS Cluster RunBook}
 * <li>the creating and deletion of Clusters and modification of their settings via
 * the {@link com.xebialabs.deployit.plugin.was.runbook.WasManagedApacheWebServerRunBook WAS Managed Apache Web Server RunBook}
 * </ul>
 * 
 * For details of the exact components supported, sequence in which steps are carried out, limitations
 * etc. please consult the documentation of the appropriate run book.
 * 
 * <h4>Mapping</h4>
 * 
 * The plugin contains the following {@link com.xebialabs.deployit.ci.artifact.DeployableArtifact Deployable artifacts} mappings: 
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasEarMapping WAS Ear Mapping} maps an {@link com.xebialabs.deployit.ci.artifact.Ear EAR} to 
 * a {@link com.xebialabs.deployit.plugin.was.ci.WasCluster WAS Cluster}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasWarMapping WAS War Mapping} maps a {@link com.xebialabs.deployit.ci.artifact.War WAR} to 
 * a {@link com.xebialabs.deployit.plugin.was.ci.WasCluster WAS Cluster}
 * </ul>
 * 
 * <p>
 * All WAS-related resources can be mapped wit the {@link com.xebialabs.deployit.plugin.was.ci.WasResourceMapping WAS resource mapping} to:
 * 
 * <ul>
 * <li>A specified {@link com.xebialabs.deployit.plugin.was.ci.WasCluster WAS Cluster} within the target {@link com.xebialabs.deployit.plugin.was.ci.WasCell WAS Cell}.
 * </ul>
 * 
 * <h3>Known limitations</h3>
 * 
 * The plugin does not currently support
 * 
 * <ul>
 * <li>Installation, maintenance or removal of WebSphere installations and profiles.
 * </ul>
 * 
 * If you have questions, comments or feedback please <a href="mailto:deployit-dev@xebialabs.com">contact</a>
 * the WebSphere development team at XebiaLabs.
 * 
 * @version 1.2
 */
package com.xebialabs.deployit.plugin.was;