package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;

/**
 * Adds a single member (Server) of a {@link WasCluster WAS Cluster} to a {@link WasNode}. The cloneNumber is used in the name of the Was Server.
 */
@SuppressWarnings("serial")
public class AddSingleWasClusterMemberStep extends WasStepBase {

	protected static final String CLONE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "clone-cluster-member.py";

	protected WasCluster cluster;

	protected WasNode node;

	private int cloneNumber;

	public AddSingleWasClusterMemberStep(WasCluster cluster, WasNode node, int cloneNumber) {
		super(cluster.getCell());
		this.cloneNumber = cloneNumber;
		this.cluster = cluster;
		this.node = node;
		setDescription("Add a member (clone) " + cloneNumber + " for cluster \"" + cluster.getLabel() + "\" on node \"" + node.getLabel() + "\" in cell \""
				+ cell.getLabel() + "\"");
	}

	public boolean execute(StepExecutionContext ctx) {
		String clusterMemberNamesPrefix = WasCluster.getMemberNamesPrefix(cluster.getName(), node.getName());
		String startOfBootstrapPortNumberRange = Integer.toString(cluster.getStartOfBootstrapPortNumberRange());
		String startOfSoapConnectorPortNumberRange = Integer.toString(cluster.getStartOfSoapConnectorPortNumberRange());

		return (executeWsadminJythonScriptResource(ctx, CLONE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH, node.getName(), cluster.getName(), clusterMemberNamesPrefix,
				Integer.toString(cloneNumber), startOfBootstrapPortNumberRange, "BOOTSTRAP_ADDRESS", startOfSoapConnectorPortNumberRange,
				"SOAP_CONNECTOR_ADDRESS") == 0);
	}

}
