package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Creates a {@link WasCluster} in a {@link WasCell}
 */
@SuppressWarnings("serial")
public class CreateWasClusterStep extends WasStepBase {

	protected static final String SCRIPT_NAME = STEP_RESOURCES_PATH + "create-cluster.py";

	protected WasCluster cluster;

	public CreateWasClusterStep(WasCluster cluster) {
		this(cluster.getCell().getHost(), cluster.getCell(), cluster);
	}

	public CreateWasClusterStep(Host cellHost, WasCell cell, WasCluster cluster) {
		super(cell);
		this.cluster = cluster;
		setDescription("Create cluster " + ExtendedStringUtils.getQuotedString(cluster.getLabel()) + " in cell " + ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		return (executeWsadminJythonScriptResource(ctx, SCRIPT_NAME, cluster.getName()) == 0);
	}

}
