package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasDataSource;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Creates a {@link WasDataSource} in a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class CreateWasDataSourceStep extends WasStepBase {

	public static final String CREATE_DATASOURCE_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-datasource.py";

	private WasDataSource wasDataSource;

	private WasCluster cluster;

	public CreateWasDataSourceStep(WasDataSource wasDataSource, WasCluster cluster) {
		super(cluster.getCell());
		this.wasDataSource = wasDataSource;
		this.cluster = cluster;
		setDescription("Create datasource " + ExtendedStringUtils.getQuotedString(wasDataSource.getLabel()) + " in cell "
				+ ExtendedStringUtils.getQuotedString(cluster.getCell().getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		return executeWsadminJythonScriptResource(ctx, CREATE_DATASOURCE_SCRIPT_RESOURCE_PATH, wasDataSource.getName(), wasDataSource.getDescription(), wasDataSource.getJndiName(),
				wasDataSource.getProvider(), wasDataSource.getDataStoreHelperClass(), wasDataSource.getUrl(), wasDataSource.getUsername(), wasDataSource
						.getPassword(), Integer.toString(wasDataSource.getStatementCacheSize()), cell.getName(), cluster.getName()) == 0;
	}

	public WasDataSource getWasDataSource() {
		return wasDataSource;
	}

	public WasCluster getCluster() {
		return cluster;
	}

}
