package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Creates a <a href="http://publib.boulder.ibm.com/infocenter/wasinfo/v6r1//index.jsp?topic=/com.ibm.websphere.base.doc/info/aes/ae/tcws_plugin_vhost.html">
 * Virtual Host</a> in a {@link WasCell}
 */
@SuppressWarnings("serial")
public class CreateWasVirtualHostStep extends WasStepBase {

	protected static final String CREATE_VIRTUAL_HOST_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-vhost.py";

	protected String vhostName;

	public CreateWasVirtualHostStep(WasCell cell, String vhostName) {
		this(cell.getHost(), cell, vhostName);
	}

	public CreateWasVirtualHostStep(Host cellHost, WasCell cell, String vhostName) {
		super(cell);
		this.vhostName = vhostName;
		setDescription("Create WAS virtual host " + vhostName + " in cell " + ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		return (executeWsadminJythonScriptResource(ctx, CREATE_VIRTUAL_HOST_SCRIPT_RESOURCE_PATH, cell.getName(), vhostName) == 0);
	}

}
