package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasNode;

/**
 * Destroys a {@link WasManagedApacheHttpdServer} in a {@link WasNode}
 */
@SuppressWarnings("serial")
public class DestroyWasManagedApacheWebServerStep extends WasStepBase {

	private static final String DESTROY_WAS_MANAGED_APACHE_WEB_SERVER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-was-managed-apache-web-server.py";

	private WasManagedApacheHttpdServer webserver;

	public DestroyWasManagedApacheWebServerStep(WasManagedApacheHttpdServer webserver) {
		super(webserver.getNode().getCell());
		this.webserver = webserver;
		setDescription("Destroy WAS managed Apache web server" + webserver + " on node " + webserver.getNode() + " in cell " + webserver.getNode().getCell());
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("webserver", webserver);
		context.put("node", webserver.getNode());
		context.put("cell", webserver.getNode().getCell());
		int res = executeWsadminJythonScriptResource(ctx, context, DESTROY_WAS_MANAGED_APACHE_WEB_SERVER_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

}
