package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;

/**
 * Removes a member of a {@link WasCluster} from a {@link WasNode}
 */
@SuppressWarnings("serial")
public class RemoveWasClusterMemberStep extends WasStepBase {

	protected static final String REMOVE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "remove-cluster-member.py";

	protected WasCluster cluster;

	protected WasNode node;

	private int cloneNumber;

	public RemoveWasClusterMemberStep(WasCluster cluster, WasNode node, int cloneNumber) {
		super(cluster.getCell());
		this.cloneNumber = cloneNumber;
		this.cluster = cluster;
		this.node = node;
		setDescription("Remove member " + cloneNumber + " for cluster \"" + cluster.getLabel() + "\" on node \"" + node.getLabel() + "\" in cell \""
				+ cell.getLabel() + "\"");
	}

	public boolean execute(StepExecutionContext ctx) {
		String clusterMemberNamesPrefix = WasCluster.getMemberNamesPrefix(cluster.getName(), node.getName());
		return (executeWsadminJythonScriptResource(ctx, REMOVE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH, node.getName(), cluster.getName(),
				clusterMemberNamesPrefix, Integer.toString(cloneNumber)) == 0);
	}

}
