import sys

sys.argv.reverse();
cellname = sys.argv.pop()
nodename = sys.argv.pop()
servername = sys.argv.pop()

print "DeployIt INFO: Configuring cluster member " + servername + " on node " + nodename + " in cell " + cellname

server = AdminConfig.getid('/Server:'+ servername +'/')
jvmConfig = AdminConfig.list("JavaVirtualMachine", server)
javaProcessDefConfig = AdminConfig.list('JavaProcessDef', server)
processExecutionConfig = AdminConfig.list('ProcessExecution', javaProcessDefConfig)
outputRedirectConfig = AdminConfig.list('OutputRedirect', javaProcessDefConfig)
applicationServerConfig = AdminConfig.list('ApplicationServer', server)
webContainerConfig = AdminConfig.list('WebContainer', server)
sessionManagerConfig = AdminConfig.list( 'SessionManager', server)
tuningParamsConfig = AdminConfig.list('TuningParams', sessionManagerConfig)
messageListenerService = AdminConfig.list('MessageListenerService', server)

while len(sys.argv) >= 2:
    propname = sys.argv.pop();
    propvalue = sys.argv.pop();
    
    print "DeployIt INFO: Setting server property " + propname + " to value \"" + propvalue + "\""

    if propname == "classpath":
        AdminConfig.modify(jvmConfig,  [['classpath',  '']])
        AdminConfig.modify(jvmConfig,  [['classpath',  propvalue]])

    elif propname == "bootclasspath":
        AdminConfig.modify(jvmConfig,  [['bootClasspath',  '']])
        AdminConfig.modify(jvmConfig,  [['bootClasspath',  propvalue]])

    elif propname == "initheapsize":
        AdminConfig.modify(jvmConfig, [['initialHeapSize', propvalue]])

    elif propname == "maxheapsize":
        AdminConfig.modify(jvmConfig, [['maximumHeapSize', propvalue]])

    elif propname == "jvmargs":
        AdminConfig.modify(jvmConfig, [['genericJvmArguments', propvalue]])

    elif propname == "disablejit":
        AdminConfig.modify(jvmConfig, [['disableJIT', propvalue]])

    elif propname == "applicationclassloaderpolicy":
        AdminConfig.modify(applicationServerConfig, [['applicationClassLoaderPolicy', propvalue]])

    elif propname == "applicationclassloadingmode":
        AdminConfig.modify(applicationServerConfig, [['applicationClassLoadingMode', propvalue]])

    elif propname == "systempropertyclear":
        AdminConfig.modify(jvmConfig, [['systemProperties', []]])

    elif propname == "workdir":
        AdminConfig.modify(javaProcessDefConfig, [['workingDirectory', propvalue]])

    elif propname == "umask":
        AdminConfig.modify(processExecutionConfig, [['umask', propvalue]])

    elif propname == "servletcaching":
        AdminConfig.modify(webContainerConfig, [['enableServletCaching', propvalue]])

    elif propname == "sessmaxinmem":
        AdminConfig.modify(tuningParamsConfig, [['maxInMemorySessionCount', propvalue]])

    elif propname == "sesstimeout":
        AdminConfig.modify(tuningParamsConfig, [['invalidationTimeout', propvalue]])

    elif propname == "sesscookieenabled":
        AdminConfig.modify(sessionManagerConfig,  [['enableCookies', propvalue]])

    elif propname == "sesscookie":
        propvalue2 = sys.argv.pop()
        propvalue3 = sys.argv.pop()
        AdminConfig.modify(sessionManagerConfig,  [['defaultCookieSettings',  [['name', propvalue],['domain', propvalue2],['path', propvalue3]] ]])

    elif propname == "listenerportclear":
        AdminConfig.modify(messageListenerService, [['listenerPorts', []]])

    elif propname == "stdoutlog":
        AdminConfig.modify(outputRedirectConfig, [['stdoutFilename', propvalue]])

    elif propname == "stderrlog":
        AdminConfig.modify(outputRedirectConfig, [['stderrFilename', propvalue]])

    elif propname == "jvmstdoutlog":
        outputStreamRedirectConfig = AdminConfig.showAttribute(server, 'outputStreamRedirect')
        AdminConfig.modify(outputStreamRedirectConfig, [['fileName', propvalue]]);
        AdminConfig.modify(outputStreamRedirectConfig, [['rolloverType', 'NONE']])

    elif propname == "jvmstderrlog":
        errorStreamRedirectConfig = AdminConfig.showAttribute(server, 'errorStreamRedirect')
        AdminConfig.modify(errorStreamRedirectConfig, [['fileName', propvalue]]);
        AdminConfig.modify(errorStreamRedirectConfig, [['rolloverType', 'NONE']])

    else:
        print "DeployIt INFO: Skipping unknown property \"" + propname + "\" with value \"" + propvalue + "\""

print "DeployIt INFO: Saving configuration"
AdminConfig.save();
