/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyWasClusterMemberStep
extends WasStepBase {
    protected static final String MODIFY_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/configure-cluster-member.py";
    protected WasCluster cluster;
    protected WasNode node;
    protected int memberNumber;

    public ModifyWasClusterMemberStep(WasCluster cluster, WasNode node, int memberNumber) {
        super(cluster.getCell());
        this.cluster = cluster;
        this.node = node;
        this.memberNumber = memberNumber;
        this.setDescription("Configure member " + memberNumber + " of cluster " + ExtendedStringUtils.getQuotedString((String)cluster.getLabel()) + " on node " + ExtendedStringUtils.getQuotedString((String)node.getLabel()) + " in cell " + ExtendedStringUtils.getQuotedString((String)this.cell.getLabel()));
    }

    public boolean execute(StepExecutionContext ctx) {
        String clusterMemberNamesPrefix = WasCluster.getMemberNamesPrefix(this.cluster.getName(), this.node.getName());
        String serverName = clusterMemberNamesPrefix + this.memberNumber;
        return this.executeWsadminJythonScriptResource(ctx, MODIFY_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH, this.getArgs(this.node.getName(), serverName).toArray(new String[0])) == 0;
    }

    private List<String> getArgs(String nodeName, String serverName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.cell.getName());
        args.add(nodeName);
        args.add(serverName);
        ModifyWasClusterMemberStep.addConfigureServerArgument("classpath", this.cluster.getClasspath(), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("bootclasspath", this.cluster.getBootClasspath(), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("initheapsize", this.cluster.getInitHeapSize(), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("maxheapsize", this.cluster.getMaxHeapSize(), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("jvmargs", this.cluster.getJvmArguments(), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("disablejit", Boolean.toString(this.cluster.getDisableJit()), args);
        if (this.cluster.getApplicationClassLoaderPolicyAndMode() != null) {
            switch (this.cluster.getApplicationClassLoaderPolicyAndMode()) {
                case MULTIPLE: {
                    args.add("applicationclassloaderpolicy");
                    args.add("MULTIPLE");
                    break;
                }
                case SINGLE_PARENT_FIRST: {
                    args.add("applicationclassloaderpolicy");
                    args.add("SINGLE");
                    args.add("applicationclassloadingmode");
                    args.add("PARENT_FIRST");
                    break;
                }
                case SINGLE_PARENT_LAST: {
                    args.add("applicationclassloaderpolicy");
                    args.add("SINGLE");
                    args.add("applicationclassloadingmode");
                    args.add("PARENT_LAST");
                }
            }
        }
        ModifyWasClusterMemberStep.addConfigureServerArgument("workdir", this.cluster.getWorkingDir(), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("umask", this.cluster.getUmask(), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("stdoutlog", ModifyWasClusterMemberStep.getLogPathForMember(serverName, this.cluster.getStdOut()), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("stderrlog", ModifyWasClusterMemberStep.getLogPathForMember(serverName, this.cluster.getStdErr()), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("jvmstdoutlog", ModifyWasClusterMemberStep.getLogPathForMember(serverName, this.cluster.getJvmStdOut()), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("jvmstderrlog", ModifyWasClusterMemberStep.getLogPathForMember(serverName, this.cluster.getJvmStdErr()), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("servletcaching", Boolean.toString(this.cluster.getServletCaching()), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("sessmaxinmem", this.cluster.getMaximumSessionsInMemory(), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("sesstimeout", this.cluster.getSessionTimeout(), args);
        ModifyWasClusterMemberStep.addConfigureServerArgument("sesscookieenabled", Boolean.toString(this.cluster.getEnableSessionCookies()), args);
        if (StringUtils.isNotBlank((String)this.cluster.getCookieName())) {
            args.add("sesscookie");
            args.add(StringUtils.defaultIfEmpty((String)this.cluster.getCookieName(), (String)"JSESSIONID"));
            args.add(StringUtils.defaultString((String)this.cluster.getCookieDomain()));
            args.add(StringUtils.defaultIfEmpty((String)this.cluster.getCookiePath(), (String)"/"));
        }
        return args;
    }

    private static String getLogPathForMember(String serverName, String logPrefix) {
        if (StringUtils.isBlank((String)logPrefix)) {
            return logPrefix;
        }
        return logPrefix + serverName + ".txt";
    }

    private static void addConfigureServerArgument(String propname, String propvalue, String suffix, List<String> args) {
        if (StringUtils.isNotBlank((String)propvalue)) {
            args.add(propname);
            if (suffix != null) {
                args.add(propvalue + suffix);
            } else {
                args.add(propvalue);
            }
        }
    }

    private static void addConfigureServerArgument(String propname, String propvalue, List<String> args) {
        ModifyWasClusterMemberStep.addConfigureServerArgument(propname, propvalue, null, args);
    }

    private static void addConfigureServerArgument(String propname, int propvalue, List<String> args) {
        if (propvalue != 0) {
            args.add(propname);
            args.add(Integer.toString(propvalue));
        }
    }
}

