/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.step.CreateWasServerStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasServerStep;
import com.xebialabs.deployit.plugin.was.step.ModifyWasServerStep;
import com.xebialabs.deployit.plugin.was.step.StartWasManagedServerStep;
import com.xebialabs.deployit.plugin.was.step.StopWasManagedServerStep;
import com.xebialabs.deployit.plugin.was.step.SynchronizeWasNodeStep;
import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasServerRunBook
extends SingleTypeHandlingRunBook<WasManagedServer>
implements RunBook {
    public WasServerRunBook() {
        super(WasManagedServer.class);
    }

    public void resolve(Change<WasManagedServer> change, ChangePlan changePlan, List<Step> steps) {
        WasManagedServer newServer;
        WasManagedServer oldServer = (WasManagedServer)change.getOldRevision();
        boolean identical = ConfigurationItemReflectionUtils.isIdentical((Serializable)oldServer, (Serializable)(newServer = (WasManagedServer)change.getNewRevision()));
        if (!identical && !this.isChangedServerAMemberOfAClusterChange(change, changePlan)) {
            if (change.isModification() && !this.modificationWillBeHandledByWasDeploymentRunBook(change, changePlan)) {
                this.getStepsForModifiedServer(steps, oldServer, newServer);
            }
            if (change.isDeletion()) {
                steps.add(new StopWasManagedServerStep(oldServer, false));
                steps.add(new DestroyWasServerStep(oldServer));
                steps.add(new SynchronizeWasNodeStep(oldServer.getNode()));
            }
            if (change.isAddition()) {
                steps.add(new CreateWasServerStep(newServer));
                steps.add(new ModifyWasServerStep(newServer));
                steps.add(new SynchronizeWasNodeStep(newServer.getNode()));
                steps.add(new StartWasManagedServerStep(newServer));
            }
        }
    }

    private boolean isChangedServerAMemberOfAClusterChange(Change<WasManagedServer> change, ChangePlan changePlan) {
        WasManagedServer server = change.isAddition() || change.isModification() ? (WasManagedServer)change.getNewRevision() : (WasManagedServer)change.getOldRevision();
        for (Change eachChange : changePlan.getChanges()) {
            Change clusterChange;
            WasCluster cluster;
            if (eachChange.getConfigurationItemClass() != WasCluster.class || !(cluster = (clusterChange = eachChange).isAddition() || clusterChange.isModification() ? (WasCluster)clusterChange.getNewRevision() : (WasCluster)clusterChange.getOldRevision()).getServers().contains(server)) continue;
            return true;
        }
        return false;
    }

    public void getStepsForModifiedServer(List<Step> steps, WasManagedServer oldServer, WasManagedServer newServer) {
        steps.add(new StopWasManagedServerStep(oldServer, false));
        steps.add(new ModifyWasServerStep(newServer));
        steps.add(new StartWasManagedServerStep(newServer));
    }

    private boolean modificationWillBeHandledByWasDeploymentRunBook(Change<WasManagedServer> serverChange, ChangePlan changePlan) {
        Change<Deployment> deploymentChange = this.findChangeForModifiedDeploymentOfModifiedServer(serverChange, changePlan);
        return deploymentChange != null;
    }

    private Change<Deployment> findChangeForModifiedDeploymentOfModifiedServer(Change<WasManagedServer> serverChange, ChangePlan changePlan) {
        if (!serverChange.isModification()) {
            return null;
        }
        for (Change change : changePlan.getChanges()) {
            if (!change.isModification() || change.getConfigurationItemClass() != Deployment.class) continue;
            WasManagedServer oldServer = (WasManagedServer)serverChange.getOldRevision();
            WasManagedServer newServer = (WasManagedServer)serverChange.getNewRevision();
            Deployment oldDeployment = (Deployment)change.getOldRevision();
            Deployment newDeployment = (Deployment)change.getNewRevision();
            boolean oldServerWasTarget = oldDeployment.getTarget().getMembersOfType(WasManagedServer.class).contains(oldServer);
            boolean newServerWasTarget = newDeployment.getTarget().getMembersOfType(WasManagedServer.class).contains(newServer);
            if (!oldServerWasTarget || !newServerWasTarget) continue;
            return change;
        }
        return null;
    }
}

