/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasUnManagedApacheHttpdServer;

/**
 * Copies the WebSphere plugin configuration file for a {@link WasUnManagedApacheHttpdServer}
 */
@SuppressWarnings("serial")
public class CopyWasWebServerPluginConfigurationStep extends WasStepBase {

	protected WasUnManagedApacheHttpdServer webserver;

	public CopyWasWebServerPluginConfigurationStep(WasUnManagedApacheHttpdServer webserver) {
		super(webserver.getNode().getCell());
		this.webserver = webserver;
		setDescription("Copy WebSphere plugin configuration file from " + webserver.getPluginCfgInWasConfigurationPath() + " on "
		        + webserver.getNode().getCell().getCellHost() + " to " + webserver.getPluginCfgOnRemoteServerPath() + " on " + webserver.getHost());
	}

	public boolean execute(StepExecutionContext ctx) {
		return copyPluginToWebserver(ctx);
	}

	private boolean copyPluginToWebserver(StepExecutionContext ctx) {
		HostSession sourceSession = webserver.getNode().getCell().connectToAdminHost();
		try {
			HostFile sourceFile = sourceSession.getFile(webserver.getPluginCfgInWasConfigurationPath());

			HostSession destinationSession = webserver.getHost().getHostSession();
			try {
				HostFile destinationFile = destinationSession.getFile(webserver.getPluginCfgOnRemoteServerPath());
				HostFile destinationParentDir = destinationFile.getParentFile();
				if (!destinationParentDir.exists()) {
					ctx.logOutput("Creating directory structure for plugin configuration file in " + destinationParentDir);
					destinationParentDir.mkdirs();
				}
				ctx.logOutput("Copying WebSphere plugin configuration file from " + webserver.getPluginCfgInWasConfigurationPath() + " on "
				        + webserver.getNode().getCell().getCellHost() + " to " + destinationFile + " on " + webserver.getHost());
				HostFileUtils.copy(sourceFile, destinationFile);
				return true;
			} finally {
				destinationSession.close();
			}
		} finally {
			sourceSession.close();
		}
	}


}
