/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;
import com.xebialabs.deployit.ci.artifact.Folder;
import com.xebialabs.deployit.ci.artifact.Libraries;
import com.xebialabs.deployit.ci.artifact.mapping.ConfigurationFilesMapping;
import com.xebialabs.deployit.ci.artifact.mapping.LibrariesMapping;
import com.xebialabs.deployit.mapper.ModificationSupportingStepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.ci.WasScope;
import com.xebialabs.deployit.plugin.was.ci.WasSharedLibrary;
import com.xebialabs.deployit.plugin.was.ci.WasSharedLibraryToWasScopeTargetMapping;
import com.xebialabs.deployit.plugin.was.step.CreateWasSharedLibraryStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasSharedLibraryStep;
import com.xebialabs.deployit.plugin.was.step.UpdateWasSharedLibraryStep;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedLibraryToWasScopeTargetMapper
extends ModificationSupportingStepGeneratingMapper<WasSharedLibrary, WasSharedLibraryToWasScopeTargetMapping, WasScope> {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

    public SharedLibraryToWasScopeTargetMapper(Change<Deployment> change) {
        super(change, false);
    }

    protected void generateAdditionStepsForAddedMapping(WasSharedLibrary sharedLibrary, WasSharedLibraryToWasScopeTargetMapping newMapping, WasScope scopeTarget, List<Step> steps) {
        String remoteHostFileSeparator = scopeTarget.getCell().getCellHost().getFileSeparator();
        Deployment deployment = (Deployment)this.change.getNewRevision();
        String completeClassPath = this.prepareCompleteClassPath(sharedLibrary, deployment, remoteHostFileSeparator);
        steps.add(new CreateWasSharedLibraryStep(sharedLibrary, scopeTarget, completeClassPath));
    }

    protected void generateDeletionStepsForDeletedMapping(WasSharedLibrary sharedLibrary, WasSharedLibraryToWasScopeTargetMapping oldVersionOfModifiedMapping, WasScope scopeTarget, List<Step> steps) {
        steps.add(new DestroyWasSharedLibraryStep(sharedLibrary, scopeTarget));
    }

    protected void generateModificationStepsForModifiedMapping(WasSharedLibrary oldSharedLibrary, WasSharedLibraryToWasScopeTargetMapping oldMapping, WasScope oldMappingTarget, WasSharedLibrary newSharedLibrary, WasSharedLibraryToWasScopeTargetMapping newMapping, WasScope newMappingTarget, List<Step> steps) {
        String newClasspath;
        String oldClasspath = this.prepareCompleteClassPath(oldSharedLibrary, (Deployment)this.change.getOldRevision(), oldMappingTarget.getCell().getCellHost().getFileSeparator());
        if (!oldClasspath.equals(newClasspath = this.prepareCompleteClassPath(newSharedLibrary, (Deployment)this.change.getNewRevision(), newMappingTarget.getCell().getCellHost().getFileSeparator()))) {
            steps.add(new UpdateWasSharedLibraryStep(newSharedLibrary, newMappingTarget, newClasspath));
        }
    }

    private String prepareCompleteClassPath(WasSharedLibrary sharedLibrary, Deployment deployment, String pathSeparator) {
        ArrayList strings = Lists.newArrayList();
        CollectionUtils.addIgnoreNull((Collection)strings, (Object)sharedLibrary.getClassPath());
        if (CollectionUtils.isNotEmpty(sharedLibrary.getConfigurationFiles())) {
            CollectionUtils.addIgnoreNull((Collection)strings, (Object)this.getClassPathEntriesForConfigFiles(deployment, sharedLibrary.getConfigurationFiles(), pathSeparator));
        }
        if (CollectionUtils.isNotEmpty(sharedLibrary.getLibraries())) {
            CollectionUtils.addIgnoreNull((Collection)strings, (Object)this.getClassPathEntriesForLibraries(deployment, sharedLibrary.getLibraries(), pathSeparator));
        }
        return StringUtils.join((Collection)strings, (String)";");
    }

    private String getClassPathEntriesForConfigFiles(Deployment deployment, Set<ConfigurationFiles> configFiles, String remoteHostFileSeparator) {
        HashSet classPathEntries = Sets.newHashSet();
        List mappingsForSource = deployment.getMappingsOfType(ConfigurationFilesMapping.class);
        for (ConfigurationFilesMapping eachMapping : mappingsForSource) {
            if (!configFiles.contains(eachMapping.getSource())) continue;
            String targetDirectory = eachMapping.getTargetDirectory();
            classPathEntries.add(targetDirectory);
        }
        return StringUtils.join((Collection)classPathEntries, (String)";");
    }

    private String getClassPathEntriesForLibraries(Deployment deployment, Set<Libraries> libraries, String remoteHostFileSeparator) {
        HashSet classPathEntries = Sets.newHashSet();
        List mappingsForSource = deployment.getMappingsOfType(LibrariesMapping.class);
        for (LibrariesMapping eachMapping : mappingsForSource) {
            if (!libraries.contains(eachMapping.getSource())) continue;
            String targetDirectory = eachMapping.getTargetDirectory();
            Folder library = (Folder)eachMapping.getSource();
            if (CollectionUtils.isEmpty((Collection)library.getFiles())) {
                classPathEntries.add(targetDirectory + remoteHostFileSeparator + library.getName());
                continue;
            }
            HashSet folderFiles = Sets.newHashSet((Iterable)library.getFiles());
            this.addFileNamesToClassPathEntries(classPathEntries, folderFiles, targetDirectory, remoteHostFileSeparator);
        }
        return StringUtils.join((Collection)classPathEntries, (String)";");
    }

    private void addFileNamesToClassPathEntries(Set<String> classPathEntries, Set<File> files, String targetDirectory, String pathSeparator) {
        for (File eachFile : files) {
            if (eachFile.isDirectory()) {
                String modifiedTargetDirectory = targetDirectory + pathSeparator + eachFile.getName();
                this.addFileNamesToClassPathEntries(classPathEntries, Sets.newHashSet((Object[])eachFile.listFiles()), modifiedTargetDirectory, pathSeparator);
                continue;
            }
            classPathEntries.add(targetDirectory + pathSeparator + eachFile.getName());
        }
    }
}

