/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.runbook;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.plugin.was.ci.WasDeploymentManager;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.step.CreateWasManagedApacheWebServerStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasManagedApacheWebServerStep;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;

/**
 * Supports the creation, modification and deletion of a 
 * {@link WasManagedApacheHttpdServer WAS Managed Apache WebServer}.
 * 
 * <h4>Conditions</h4>
 * 
 * Will trigger if the change plan contains the addition, modification or
 * deletion of a {@link WasManagedApacheHttpdServer WAS Managed Apache WebServer}.
 * 
 * <h4>Actions</h4>
 * 
 * Addition:
 * 
 * <ol>
 * <li>Create {@link WasManagedApacheHttpdServer WAS Managed Apache WebServer} in a {@link WasDeploymentManager cell}
 * </ol>
 * 
 * All Modifications are handled as Deletion and Addition.
 * <p>
 * Deletion:
 * 
 * <ol>
 * <li>Delete {@link WasManagedApacheHttpdServer WAS Managed Apache WebServer} from a {@link WasDeploymentManager cell}
 * </ol>
 */
public class WasManagedApacheWebServerRunBook extends SingleTypeHandlingRunBook<WasManagedApacheHttpdServer> implements RunBook {

	public WasManagedApacheWebServerRunBook() {
		super(WasManagedApacheHttpdServer.class);
	}

	@Override
	protected void resolve(Change<WasManagedApacheHttpdServer> change, ChangePlan changePlan, List<Step> steps) {
		if (change.isDeletion() || change.isModification()) {
			destroyWasManagedApacheWebServer(change, steps);
		}

		if (change.isAddition()|| change.isModification()) {
			createWasManagedApacheWebServer(change, steps);
		}
	}

	private void createWasManagedApacheWebServer(Change<WasManagedApacheHttpdServer> change, List<Step> steps) {
		steps.add(new CreateWasManagedApacheWebServerStep(change.getNewRevision()));
	}

	private void destroyWasManagedApacheWebServer(Change<WasManagedApacheHttpdServer> change, List<Step> steps) {
		steps.add(new DestroyWasManagedApacheWebServerStep(change.getOldRevision()));
	}

}
