/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;

public class EarToWasServerMapper extends JeeWebArtifactToWasTargetMapper<Ear, WasEarMapping, WasManagedServer> {

	public EarToWasServerMapper(Change<Deployment> change) {
		super(change, false);
	}

	@Override
	protected void generateDeployStep(Ear artifact, WasEarMapping mapping, WasManagedServer server, Collection<WasManagedApacheHttpdServer> webservers,
	        List<Step> steps) {
		// vhost name == artifact's name (see generateAdditionStepsForAddedMapping in JeeArtifactToWasClusterMapper)
		steps.add(new WasDeployApplicationStep(server.getCell(), mapping.getArtifact(), Collections.singleton(server), webservers, artifact.getName(), mapping
		        .getSharedLibraries(), mapping.getStartingWeight(), mapping.getClassLoaderMode(), mapping.getClassLoaderPolicy(), mapping
		        .getWarClassLoaderMapping(), mapping.getSecurityRoleUserGroupMappings(), getUpdatedWebserversMapping(mapping)));
	}

	@Override
	protected void generateUndeployStep(Ear artifact, WasManagedServer server, WasEarMapping mapping, List<Step> steps) {
		steps.add(new WasUndeployApplicationStep(server.getCell(), mapping.getArtifact()));
	}

	@Override
	protected void generateStartStep(Ear artifact, WasManagedServer server, WasEarMapping mapping, List<Step> steps) {
		steps.add(new WasStartApplicationStep(server, mapping.getArtifact()));
	}

	@Override
	protected void generateStopStep(Ear artifact, WasManagedServer server, WasEarMapping mapping, List<Step> steps) {
		steps.add(new WasStopApplicationStep(server, mapping.getArtifact()));
	}

	@Override
	protected String getVirtualHostFromMapping(WasEarMapping mapping) {
		return mapping.getVirtualHost();
	}

	@Override
	public void setDefaults(Deployment d, WasEarMapping m) {
		m.setVirtualHost(d.getVhostDefinition());
	}

	@Override
    protected List<WarsWebserversVirtualHostMapping> getWebserversAndVirtualHostPerWar(WasEarMapping mapping) {
	    return mapping.getWarsWebserversVHMapping();
    }
	
	@Override
    protected List<WarsWebserversVirtualHostMapping> getFileServingEnabledPerWars(WasEarMapping mapping) {
	    return getWebserversAndVirtualHostPerWar(mapping);
    }
	
}
