/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasDeploymentManager;
import com.xebialabs.deployit.plugin.was.ci.WasUnManagedApacheHttpdServer;

/**
 * Tells the {@link WasDeploymentManager} to copy plugin configuration for a {@link WasUnManagedApacheHttpdServer}
 */
@SuppressWarnings("serial")
public class CopyWasWebServerPluginConfigurationStep extends WasStepBase {

	protected WasUnManagedApacheHttpdServer webserver;

	public CopyWasWebServerPluginConfigurationStep(WasUnManagedApacheHttpdServer webserver) {
		super(webserver.getNode().getCell());
		this.webserver = webserver;
		String fileSeparator = webserver.getHost().getFileSeparator();
		String webserverPluginFile = webserver.getPluginInstallationDirPath() + fileSeparator + webserver.getName() + fileSeparator
		        + "plugin-cfg.xml";
		this.description = "Copy  plugin from location \"" + getPluginConfigurationFilePath() + "\" on Host \""
		        + webserver.getNode().getCell().getCellHost().getLabel() + "\" to \"" + webserverPluginFile + "\" on Host \"" + webserver.getHost().getLabel()
		        + "\"";
	}

	public boolean execute(StepExecutionContext ctx) {
		return copyPluginToWebserver(ctx);
	}

	private boolean copyPluginToWebserver(StepExecutionContext ctx) {
		HostSession sourceSession = webserver.getNode().getCell().connectToAdminHost();
		HostSession destinationSession = webserver.getHost().getHostSession();
		try {
			HostFile sourceFile = sourceSession.getFile(getPluginConfigurationFilePath());
			String fileSeparator = webserver.getHost().getFileSeparator();
			
			//create the plugin config directory on the remote host
			String pluginConfDirectory = webserver.getPluginInstallationDirPath() + fileSeparator + webserver.getName();
			HostFile destinationPluginConfDirectory = destinationSession.getFile(pluginConfDirectory);
			destinationPluginConfDirectory.mkdirs();
			
			String webserverPluginFile = pluginConfDirectory + fileSeparator + "plugin-cfg.xml";
			HostFile destinationFile = destinationSession.getFile(webserverPluginFile);
			HostFileUtils.copy(sourceFile, destinationFile);
			ctx.logOutput("Copied  plugin  successfully from location \"" + getPluginConfigurationFilePath() + "\" on Host \""
			        + webserver.getNode().getCell().getCellHost().getLabel() + "\" to \"" + webserverPluginFile + "\" on Host \""
			        + webserver.getHost().getLabel() + "\"");
			return true;
		} finally {
			sourceSession.close();
			destinationSession.close();
		}
	}

	public String getPluginConfigurationFilePath() {
		return webserver.getNode().getCell().getWasHome() + "/config/cells/" + webserver.getNode().getCell().getCellName() + "/nodes/"
		        + webserver.getNode().getNodeName() + "/servers/" + webserver.getName().trim() + "/plugin-cfg.xml";
	}

}
