#
# Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys;

dsName					= sys.argv.pop(0)
dsDescription			= sys.argv.pop(0)
jndiName				= sys.argv.pop(0)
providerName			= sys.argv.pop(0)
datastoreHelperClassName = sys.argv.pop(0)


url						= sys.argv.pop(0)
databaseName			= sys.argv.pop(0)
databaseServerName		= sys.argv.pop(0)
databasePortNumber		= sys.argv.pop(0)


username				= sys.argv.pop(0)
password				= sys.argv.pop(0)
stmtCacheSize			= sys.argv.pop(0)
cellName                = sys.argv.pop(0)
targetType              = sys.argv.pop(0)
targetName              = sys.argv.pop(0)
shortTypeDesc           = sys.argv.pop(0)

providerId = AdminConfig.getid('/' + targetType + ':' + targetName + '/JDBCProvider:' + providerName);
if providerId != "":
	print "Using JDBC provider at " + shortTypeDesc + " scope"
	jaasName = shortTypeDesc + '_' + targetName + '_' + dsName + '_user'
else:
	providerId = AdminConfig.getid('/Cell:' + cellName + '/JDBCProvider:' + providerName);
	jaasName = dsName + '_user'
	if providerId == "":
		print "Cannot find JDBC provider " + providerName
		sys.exit(-1)
	print "Using JDBC provider at cell scope"

securityid = AdminConfig.list('Security')
if securityid == "":
	print "Cannot find Security node"
	sys.exit(-1)

print "Creating JAAS/J2C authentication data " + jaasName
authdataId = AdminConfig.create('JAASAuthData', securityid, [['alias', jaasName], ['userId', username], ['password', password]])

if url == "":
	resourceProperties = ' -configureResourceProperties [[databaseName java.lang.String ' + databaseName + '][serverName java.lang.String ' + databaseServerName + '][portNumber java.lang.Integer ' + databasePortNumber + ']]]'
else:
	resourceProperties = ' -configureResourceProperties [[URL java.lang.String ' + url + ']]]'

print "Creating JDBC DataSource " + dsName
dsId = AdminTask.createDatasource(providerId,
	'[-name "' + dsName + '"' +
	' -description "' + dsDescription + '"' +
	' -jndiName "' + jndiName + '"' +
	' -dataStoreHelperClassName "'+ datastoreHelperClassName + '"' +
	' -componentManagedAuthenticationAlias "' + jaasName + '"' +
	resourceProperties)

print "Setting statementCacheSize on JDBC DataSource " + dsName
AdminConfig.modify(dsId, [['statementCacheSize', stmtCacheSize]]);

print "Saving configuration"
AdminConfig.save();