/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCellConfigurationExecutor;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasManagedServer;
import com.xebialabs.deployit.plugin.was.ci.WasNodeAgent;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.ci.WasVersion;
import com.xebialabs.deployit.plugin.was.step.CheckServerIsInClusterStep;
import com.xebialabs.deployit.plugin.was.step.CheckServerIsOnNodeStep;
import com.xebialabs.deployit.plugin.was.step.CheckWasAdminAvailableStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasCellNameStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasSubtypesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasVersionStep;
import com.xebialabs.deployit.step.CheckDirExistsStep;
import com.xebialabs.deployit.step.CheckFileExistenceStep;
import com.xebialabs.deployit.step.HostConnectionStep;
import com.xebialabs.deployit.util.LoggingStepExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(category="middleware", description="A WebSphere Application Server deployment manager (WAS ND)", discoverable=true)
public class WasDeploymentManager
extends BaseConfigurationItem
implements WasCell,
Discoverable<WasDeploymentManager> {
    @ConfigurationItemProperty
    private Host host;
    @ConfigurationItemProperty(required=true, label="WebSphere name", identifying=true, description="Name of the WebSphere cell, e.g. MyCell, WASCell, Cell01")
    private String name;
    @ConfigurationItemProperty(required=true, label="Deployment manager profile path", description="Root path of the WebSphere deployment manager profile. e.g. /opt/ws/6.1/profiles/dmgr", size=ConfigurationItemProperty.Size.LARGE, discoveryParam=true)
    private String wasHome;
    @ConfigurationItemProperty(required=false, label="Administrative port", description="TCP port which is used to login to the WebSphere deployment manager, default is 8879")
    private int port;
    @ConfigurationItemProperty(required=false, label="Administrative username", description="Username which is used to login to the WebSphere deployment manager", discoveryParam=true)
    private String username;
    @ConfigurationItemProperty(required=false, label="Administrative password", description="Password which is used to login to the WebSphere deployment manager", password=true, discoveryParam=true)
    private String password;
    @ConfigurationItemProperty(required=true, label="WAS version", description="Version of WebSphere Application Server")
    private WasVersion version;
    protected transient WasCellConfigurationExecutor executor;
    private static Logger logger = Logger.getLogger(WasDeploymentManager.class);

    private WasCellConfigurationExecutor getWasCellConfigurationExecutor() {
        if (this.executor == null) {
            this.executor = new WasCellConfigurationExecutor(this);
        }
        return this.executor;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCellName() {
        return this.name;
    }

    @Override
    public void setCellName(String cellName) {
        this.name = cellName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getWasHome() {
        return this.wasHome;
    }

    @Override
    public void setWasHome(String wasHome) {
        this.wasHome = wasHome;
    }

    @Override
    public WasVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(WasVersion version) {
        this.version = version;
    }

    public WasDeploymentManager discover(Map<String, Object> discoveredAdditionalInfo, ChangePlan cp) {
        List<Step> steps = this.getCheckSteps();
        cp.addSteps(steps);
        cp.execute(discoveredAdditionalInfo);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WasDeploymentManager discoverChildrenInfo(Map<String, Object> discoveredAdditionalInfo, ChangePlan cp) {
        LoggingStepExecutionContext context = new LoggingStepExecutionContext(logger);
        try {
            ArrayList<WasNodeAgent> discoveredNodes = new ArrayList<WasNodeAgent>();
            Object children = discoveredAdditionalInfo.get("WasNode");
            if (children != null) {
                for (String nodeName : (Collection)children) {
                    WasNodeAgent discoveredNode = new WasNodeAgent();
                    discoveredNode.setCell(this);
                    discoveredNode.setName(nodeName);
                    discoveredNode.setLabel("Node " + nodeName + " on " + this.getName());
                    discoveredNodes.add(discoveredNode);
                }
            }
            discoveredAdditionalInfo.put("com.xebialabs.deployit.plugin.was.ci.WasNodeAgent", discoveredNodes);
            discoveredAdditionalInfo.remove("WasNode");
            ArrayList<WasManagedServer> discoveredServers = new ArrayList<WasManagedServer>();
            ArrayList discoveredWebServers = new ArrayList();
            children = discoveredAdditionalInfo.get("WasServer");
            if (children != null) {
                for (String serverName : (Collection)children) {
                    Object discoveredServer = new WasManagedServer();
                    ((WasServer)discoveredServer).setName(serverName);
                    ((WasManagedServer)discoveredServer).setNode(this.getNodeForServer(serverName, discoveredNodes, (StepExecutionContext)context));
                    String type = this.getApplicationServerType((WasManagedServer)discoveredServer, (StepExecutionContext)context);
                    if (type != null && type.equals("APPLICATION_SERVER")) {
                        discoveredServer.setLabel("Server " + serverName + " on " + ((WasManagedServer)discoveredServer).getNode().getLabel());
                        discoveredServer = ((WasManagedServer)discoveredServer).discover((Map)discoveredAdditionalInfo, cp);
                        discoveredServers.add((WasManagedServer)discoveredServer);
                        continue;
                    }
                    if (type == null || !type.equals("WEB_SERVER")) continue;
                    logger.info((Object)"Not discovering a web server");
                }
            }
            discoveredAdditionalInfo.put("com.xebialabs.deployit.plugin.was.ci.WasManagedServer", discoveredServers);
            discoveredAdditionalInfo.put("com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer", discoveredWebServers);
            discoveredAdditionalInfo.remove("WasServer");
            ArrayList<Object> discoveredClusters = new ArrayList<Object>();
            children = discoveredAdditionalInfo.get("WasCluster");
            if (children != null) {
                for (String clusterName : (Collection)children) {
                    Object discoveredCluster = new WasCluster();
                    ((WasCluster)discoveredCluster).setName(clusterName);
                    ((WasCluster)discoveredCluster).setCell(this);
                    discoveredCluster.setLabel("Cluster " + ((WasCluster)discoveredCluster).getName() + " on " + this.getName());
                    discoveredCluster = ((WasCluster)discoveredCluster).discover((Map)discoveredAdditionalInfo, cp);
                    ((WasCluster)discoveredCluster).setServers(this.getServersForCluster(clusterName, discoveredServers, context));
                    discoveredClusters.add(discoveredCluster);
                }
            }
            discoveredAdditionalInfo.put("com.xebialabs.deployit.plugin.was.ci.WasCluster", discoveredClusters);
            discoveredAdditionalInfo.remove("WasCluster");
            WasDeploymentManager wasDeploymentManager = this;
            return wasDeploymentManager;
        }
        finally {
            context.destroy();
        }
    }

    private String getApplicationServerType(WasManagedServer server, StepExecutionContext context) {
        context.logOutput("Retrieving type of server " + server);
        Map<String, String> serverProperties = this.getObjectInfo(context, "/Cell:" + server.getNode().getCell().getName() + "/Node:" + server.getNode().getName() + "/Server:" + server.getName());
        if (serverProperties == null) {
            logger.error((Object)("Did not received server properties for : /Cell:" + server.getNode().getCell().getName() + "/Node:" + server.getNode().getName() + "/Server:" + server.getName()));
        }
        return serverProperties.get("serverType");
    }

    private WasNodeAgent getNodeForServer(String serverName, List<WasNodeAgent> discoveredNodes, StepExecutionContext context) {
        for (WasNodeAgent node : discoveredNodes) {
            context.logOutput("Checking server " + serverName + " is on node " + node);
            CheckServerIsOnNodeStep checkServerIsOnNode = new CheckServerIsOnNodeStep(serverName, node);
            if (!checkServerIsOnNode.execute(context)) continue;
            return node;
        }
        return null;
    }

    private Set<WasManagedServer> getServersForCluster(String clusterName, List<WasManagedServer> discoveredServers, LoggingStepExecutionContext context) {
        HashSet<WasManagedServer> serversInThisCluster = new HashSet<WasManagedServer>();
        context.logOutput("Retrieving servers  in cluster " + clusterName);
        for (WasManagedServer server : discoveredServers) {
            CheckServerIsInClusterStep checkServerIsInCluster = new CheckServerIsInClusterStep(clusterName, server);
            boolean serverIsInCluster = checkServerIsInCluster.execute((StepExecutionContext)context);
            if (!serverIsInCluster) continue;
            serversInThisCluster.add(server);
        }
        return serversInThisCluster;
    }

    private List<Step> getCheckSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add((Step)new HostConnectionStep(this.getHost()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getWasHome()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getConfigDirPath()));
        steps.add((Step)new CheckFileExistenceStep(this.getHost(), this.getVersionInfoPath(), true, false, true));
        steps.add(new RetrieveWasVersionStep(this));
        steps.add((Step)new CheckFileExistenceStep(this.getHost(), this.getWsadminPath(), true, false, true));
        steps.add(new CheckWasAdminAvailableStep(this));
        steps.add(new RetrieveWasCellNameStep(this));
        steps.add(new RetrieveWasSubtypesStep(this));
        return steps;
    }

    @Override
    public Host getCellHost() {
        return this.host;
    }

    @Override
    public HostSession connectToAdminHost() {
        return this.getWasCellConfigurationExecutor().connectToAdminHost();
    }

    @Override
    public int executeWsadminJythonScript(StepExecutionContext ctx, HostSession cellHostSession, String scriptPath, String ... args) {
        return this.executor.executeWsadminJythonScript(ctx, cellHostSession, scriptPath, args);
    }

    @Override
    public Map<String, String> getCellPropertiesInfo(StepExecutionContext ctx) {
        return this.getWasCellConfigurationExecutor().getCellPropertiesInfo(ctx);
    }

    @Override
    public Map<String, String> getObjectInfo(StepExecutionContext ctx, String objectContainmentPath) {
        return this.getWasCellConfigurationExecutor().getObjectInfo(ctx, objectContainmentPath);
    }

    @Override
    public Map<String, String> getObjectInfoWithSubLevelByName(StepExecutionContext ctx, String objectContainmentPath, String subLevelName) {
        return this.getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByName(ctx, objectContainmentPath, subLevelName);
    }

    @Override
    public Map<String, String> getObjectInfoWithSubLevelByType(StepExecutionContext ctx, String objectContainmentPath, String subLevelType) {
        return this.getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByType(ctx, objectContainmentPath, subLevelType);
    }

    @Override
    public Map<String, String> getObjectInfoWithSubLevelByTypeAndName(StepExecutionContext ctx, String objectContainmentPath, String subLevelType, String subLevelName) {
        return this.getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByTypeAndName(ctx, objectContainmentPath, subLevelType, subLevelName);
    }

    @Override
    public Collection<String> getObjectInfoWithSubLevelByTypeNamesOnly(StepExecutionContext ctx, String objectContainmentPath, String subLevelType) {
        return this.getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByTypeNamesOnly(ctx, objectContainmentPath, subLevelType);
    }

    @Override
    public String getConfigDirPath() {
        return this.getWasCellConfigurationExecutor().getConfigDirPath();
    }

    @Override
    public String getPluginFilePath() {
        return this.getWasCellConfigurationExecutor().getPluginFilePath();
    }

    @Override
    public String getVersionInfoPath() {
        return this.getWasCellConfigurationExecutor().getVersionInfoPath();
    }

    @Override
    public String getWsadminPath() {
        return this.getWasCellConfigurationExecutor().getWsadminPath();
    }

    @Override
    public String getStartServerPath() {
        return this.getWasCellConfigurationExecutor().getStartServerPath();
    }

    @Override
    public String getStopServerPath() {
        return this.getWasCellConfigurationExecutor().getStopServerPath();
    }

    @Override
    public String getServerStatusPath() {
        return this.getWasCellConfigurationExecutor().getServerStatusPath();
    }

    @Override
    public WasCell getCell() {
        return this;
    }

    @Override
    public String getShortTypeDescription() {
        return "cell";
    }

    @Override
    public String getWasConfigIdType() {
        return "Cell";
    }

    @Override
    public String getWasTargetType() {
        return "Cell";
    }
}

