/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.utils;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.was.ci.SecurityRoleUserGroupMappings;
import com.xebialabs.deployit.plugin.was.utils.WasUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasWarUtils {
    public static Set<String> getSecurityRoles(War war) {
        HashSet<String> securityRolesList = new HashSet<String>();
        NodeList securityRoles = WasUtils.getNodesWithTag("security-role", (NamedDeployableArtifact)war, "WEB-INF/web.xml");
        if (securityRoles != null) {
            for (int i = 0; i < securityRoles.getLength(); ++i) {
                Element securityRole = (Element)securityRoles.item(i);
                String name = WasUtils.findName(securityRole, "role-name");
                if (name == null) continue;
                securityRolesList.add(name);
            }
        }
        return securityRolesList;
    }

    public static List<SecurityRoleUserGroupMappings> getSecurityRoleUserGroupMappings(War source) {
        ArrayList securityRoleUserGroupMappingsList = Lists.newArrayList();
        Set<String> securityroles = WasWarUtils.getSecurityRoles(source);
        for (String roleName : securityroles) {
            SecurityRoleUserGroupMappings securityRoleUserGroupMapping = new SecurityRoleUserGroupMappings(roleName, "", "");
            securityRoleUserGroupMappingsList.add(securityRoleUserGroupMapping);
        }
        return securityRoleUserGroupMappingsList;
    }
}

