/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import java.util.Collections;
import java.util.List;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;

@SuppressWarnings("serial")
public abstract class WasServer extends BaseConfigurationItem implements WasTarget {

	@ConfigurationItemProperty(required = true, label = "WebSphere name", identifying = true, description = "Name of the WebSphere server, e.g. server1")
	private String name;

	@ConfigurationItemProperty(required = false, label = "Classpath", description = "Classpath for this server.", size = Size.LARGE, category = "JVM")
	private String classpath;

	@ConfigurationItemProperty(required = false, label = "Boot classpath", description = "Boot classpath for this server.", size = Size.LARGE, category = "JVM")
	private String bootClasspath;

	@ConfigurationItemProperty(required = false, label = "Initial heap size", description = "Initial heap size to be allocated to the JVM (in megabytes).", size = Size.SMALL, category = "JVM")
	private int initHeapSize;

	@ConfigurationItemProperty(required = false, label = "Maximum heap size", description = "Maximum heap size to be allocated to the JVM (in megabytes).", size = Size.SMALL, category = "JVM")
	private int maxHeapSize;

	@ConfigurationItemProperty(required = false, label = "JVM arguments", description = "Generic JVM arguments.", size = Size.LARGE, category = "JVM")
	private String jvmArguments;

	@ConfigurationItemProperty(required = false, label = "Disable JIT", description = "Disable just-in-time compiler.", category = "JVM")
	private boolean disableJit;

	@ConfigurationItemProperty(required = false, label = "Classloader policy and mode", description = "Server-wide application classloader policy and mode", category = "JVM")
	private WasClassLoaderPolicyAndMode applicationClassLoaderPolicyAndMode;

	@ConfigurationItemProperty(required = false, label = "Working directory", description = "Working directory of started process.", size = Size.LARGE, category = "JVM")
	private String workingDir;

	@ConfigurationItemProperty(required = false, label = "Unix umask", description = "Umask of started process.", category = "JVM")
	private String umask;

	@ConfigurationItemProperty(required = false, label = "Stdout logfile path", description = "Path to the stdout log file. Example; /data/waslogs/stdout.log", size = Size.LARGE, category = "Logging")
	private String stdOut;

	@ConfigurationItemProperty(required = false, label = "Stderr logfile path", description = "Path to the stderr log file. Example; /data/waslogs/stderr.log", size = Size.LARGE, category = "Logging")
	private String stdErr;

	@ConfigurationItemProperty(required = false, label = "JVM stdout logfile path", description = "Path to the JVM stdout log file. Example; /data/waslogs/jvm_stdout.log", size = Size.LARGE, category = "Logging")
	private String jvmStdOut;

	@ConfigurationItemProperty(required = false, label = "JVM stderr logfile path", description = "Path to the JVM stderr log file. Example; /data/waslogs/jvm_stderr.log", size = Size.LARGE, category = "Logging")
	private String jvmStdErr;

	@ConfigurationItemProperty(required = false, label = "Enable servlet caching", category = "Web container")
	private boolean servletCaching = false;

	@ConfigurationItemProperty(required = false, label = "Session timeout", description = "HTTP session timeout in minutes", category = "Web container")
	private int sessionTimeout = 30;

	@ConfigurationItemProperty(required = false, label = "Max # of sessions in memory", description = "Maximum # of HTTP sessions in memory", category = "Web container")
	private int maximumSessionsInMemory = 1000;

	@ConfigurationItemProperty(required = false, label = "Enable session cookies", category = "Web container")
	private boolean enableSessionCookies = false;

	@ConfigurationItemProperty(required = false, label = "Session cookie name", category = "Web container")
	private String cookieName = null;

	@ConfigurationItemProperty(required = false, label = "Session cookie domain", category = "Web container")
	private String cookieDomain = null;

	@ConfigurationItemProperty(required = false, label = "Session cookie path", category = "Web container")
	private String cookiePath = null;

	@ConfigurationItemProperty(required = false, label = "Environment entries", category = "JVM")
	private List<KeyValuePair> environmentEntries = Lists.newArrayList();

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getClasspath() {
		return classpath;
	}

	public void setClasspath(String classpath) {
		this.classpath = classpath;
	}

	public String getBootClasspath() {
		return bootClasspath;
	}

	public void setBootClasspath(String bootClasspath) {
		this.bootClasspath = bootClasspath;
	}

	public int getInitHeapSize() {
		return initHeapSize;
	}

	public void setInitHeapSize(int initHeapSize) {
		this.initHeapSize = initHeapSize;
	}

	public int getMaxHeapSize() {
		return maxHeapSize;
	}

	public void setMaxHeapSize(int maxHeapSize) {
		this.maxHeapSize = maxHeapSize;
	}

	public String getJvmArguments() {
		return jvmArguments;
	}

	public void setJvmArguments(String jvmArguments) {
		this.jvmArguments = jvmArguments;
	}

	public boolean getDisableJit() {
		return disableJit;
	}

	public void setDisableJit(boolean disableJit) {
		this.disableJit = disableJit;
	}

	public WasClassLoaderPolicyAndMode getApplicationClassLoaderPolicyAndMode() {
		return applicationClassLoaderPolicyAndMode;
	}

	public void setApplicationClassLoaderPolicyAndMode(WasClassLoaderPolicyAndMode applicationClassLoaderPolicyAndMode) {
		this.applicationClassLoaderPolicyAndMode = applicationClassLoaderPolicyAndMode;
	}

	public String getWorkingDir() {
		return workingDir;
	}

	public void setWorkingDir(String workingDir) {
		this.workingDir = workingDir;
	}

	public String getUmask() {
		return umask;
	}

	public void setUmask(String umask) {
		this.umask = umask;
	}

	public String getStdOut() {
		return stdOut;
	}

	public void setStdOut(String stdOut) {
		this.stdOut = stdOut;
	}

	public String getStdErr() {
		return stdErr;
	}

	public void setStdErr(String stdErr) {
		this.stdErr = stdErr;
	}

	public String getJvmStdOut() {
		return jvmStdOut;
	}

	public void setJvmStdOut(String jvmStdOut) {
		this.jvmStdOut = jvmStdOut;
	}

	public String getJvmStdErr() {
		return jvmStdErr;
	}

	public void setJvmStdErr(String jvmStdErr) {
		this.jvmStdErr = jvmStdErr;
	}

	public boolean getServletCaching() {
		return servletCaching;
	}

	public void setServletCaching(boolean servletCaching) {
		this.servletCaching = servletCaching;
	}

	public int getSessionTimeout() {
		return sessionTimeout;
	}

	public void setSessionTimeout(int sessionTimeout) {
		this.sessionTimeout = sessionTimeout;
	}

	public int getMaximumSessionsInMemory() {
		return maximumSessionsInMemory;
	}

	public void setMaximumSessionsInMemory(int maximumSessionsInMemory) {
		this.maximumSessionsInMemory = maximumSessionsInMemory;
	}

	public boolean getEnableSessionCookies() {
		return enableSessionCookies;
	}

	public void setEnableSessionCookies(boolean enableSessionCookies) {
		this.enableSessionCookies = enableSessionCookies;
	}

	public String getCookieName() {
		return cookieName;
	}

	public void setCookieName(String cookieName) {
		this.cookieName = cookieName;
	}

	public String getCookieDomain() {
		return cookieDomain;
	}

	public void setCookieDomain(String cookieDomain) {
		this.cookieDomain = cookieDomain;
	}

	public String getCookiePath() {
		return cookiePath;
	}

	public void setCookiePath(String cookiePath) {
		this.cookiePath = cookiePath;
	}

	public abstract String getNodeName();

	public List<KeyValuePair> getEnvironmentEntries() {
		return environmentEntries;
	}

	public void setEnvironmentEntries(final List<KeyValuePair> environmentEntries) {
		this.environmentEntries = environmentEntries;
	}

	public List<String> getApplicationManagerObjectNames() {
		String appMgrObjectName = "cell=" + getCell().getCellName() + ",node=" + getNodeName() + ",type=ApplicationManager,process=" + getName() + ",*";
		return Collections.singletonList(appMgrObjectName);
	}

}
