/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Base class for WAS steps.
 */
@SuppressWarnings("serial")
public abstract class WasStepBase implements Step {

	public static final String STEP_RESOURCES_PATH = "com/xebialabs/deployit/plugin/was/step/";

	protected String description;

	protected WasCell cell;

	protected WasStepBase(WasCell cell) {
		this.cell = checkNotNull(cell);
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int executeWsadminJythonScriptResource(StepExecutionContext ctx, HostSession s, String scriptResourcePath, String... args) {
		String scriptPath = s.copyToTemporaryFile(new ClassPathResource(scriptResourcePath)).getPath();
		return cell.executeWsadminJythonScript(ctx, s, scriptPath, args);
	}

	public int executeWsadminJythonScriptResource(StepExecutionContext ctx, String scriptResourcePath, String... args) {
		HostSession s = cell.connectToAdminHost();
		try {
			return executeWsadminJythonScriptResource(ctx, s, scriptResourcePath, args);
		} finally {
			s.close();
		}
	}

	public int executeWsadminJythonScriptResource(StepExecutionContext ctx, Map<String, Serializable> context, String scriptResourcePath, String... args) {
		HostSession s = cell.connectToAdminHost();
		try {
			StringBuilder c = new StringBuilder();
			for (Map.Entry<String, Serializable> contextEntry : context.entrySet()) {
				String contextObjectName = contextEntry.getKey();
				Serializable contextObject = contextEntry.getValue();

				c.append(contextObjectName + " = {}\n");
				try {
					BeanInfo beanInfo = Introspector.getBeanInfo(contextObject.getClass());
					for (PropertyDescriptor eachPropertyDescriptor : beanInfo.getPropertyDescriptors()) {
						String fieldName = eachPropertyDescriptor.getName();
						try {
							Object fieldValueAsObject = eachPropertyDescriptor.getReadMethod().invoke(contextObject);
							if (fieldValueAsObject != null) {
								String fieldValueAsString = encodeAsPythonString(fieldValueAsObject);
								if (fieldValueAsString != null) {
									c.append(contextObjectName + "[\'" + fieldName + "\'] = \'" + fieldValueAsString + "\'\n");
								}
							}
						} catch (IllegalAccessException exc) {
							logger.warn("Cannot retrieve field values from object " + contextObjectName + ". Ignoring it.", exc);
						} catch (InvocationTargetException exc) {
							logger.warn("Cannot retrieve field values from object " + contextObjectName + ". Ignoring it.", exc);
						}
					}
				} catch (IntrospectionException exc) {
					logger.warn("Cannot retrieve field values from object " + contextObjectName + ". Ignoring it.", exc);
				}
			}
			c.append("execfile(sys.argv.pop(0))\n");

			HostFile contextScript = s.getTempFile("context-for-" + FilenameUtils.getBaseName(scriptResourcePath), ".py");
			byte[] contextBytes;
			try {
				contextBytes = c.toString().getBytes("UTF-8");
			} catch (UnsupportedEncodingException unexpected) {
				throw new IllegalStateException(unexpected);
			}
			contextScript.put(new ByteArrayInputStream(contextBytes), contextBytes.length);
			String contextScriptPath = contextScript.getPath();

			String scriptPath = s.copyToTemporaryFile(new ClassPathResource(scriptResourcePath)).getPath();

			String[] newArgs = new String[args.length + 1];
			newArgs[0] = scriptPath;
			System.arraycopy(args, 0, newArgs, 1, args.length);

			return cell.executeWsadminJythonScript(ctx, s, contextScriptPath, newArgs);
		} finally {
			s.close();
		}
	}

	private static String encodeAsPythonString(Object fieldValueAsObject) {
		StringBuilder b = new StringBuilder();
		String s = fieldValueAsObject.toString();
		if (s == null) {
			return null;
		}
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			switch (c) {
			case '\n':
				b.append("\\n");
				break;
			case '\r':
				b.append("\\r");
				break;
			case '\t':
				b.append("\\t");
				break;
			case '\\':
				b.append("\\\\");
				break;
			default:
				if (c >= ' ') {
					b.append(c);
				}
				break;
			}
		}
		return b.toString();
	}

	private static Logger logger = Logger.getLogger(WasStepBase.class);

}
