/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;
import com.xebialabs.deployit.plugin.was.ci.SecurityRoleUserGroupMappings;
import com.xebialabs.deployit.plugin.was.ci.WasClassLoaderMode;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasSharedLibrary;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.utils.WasWarUtils;
import com.xebialabs.deployit.plugin.was.utils.WebSphereNameBuilder;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="A mapping of a WAR to WebSphere middleware")
public class WasWarMapping
extends WarMapping<WasTarget> {
    @ConfigurationItemProperty(description="Set of webservers that expose the Eneterprise Application")
    private Set<WasManagedApacheHttpdServer> webservers;
    @ConfigurationItemProperty(description="Specifies the order in which applications are started. Lower values start earlier.")
    private int startingWeight = 1;
    @ConfigurationItemProperty(description="Set of shared library which will used by the war", category="Shared library references")
    private Set<WasSharedLibrary> sharedLibraries;
    @ConfigurationItemProperty(description="Specifies the Classloader mode", category="Class loading")
    private WasClassLoaderMode classLoaderMode;
    @ConfigurationItemProperty(description="Map Security role to users and groups used by EnterPrise Application", category="Security")
    private List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappings;
    @ConfigurationItemProperty(description="If true, the artifact name will be suffixed with the name of the target.")
    private boolean suffixArtifactNameWithTarget = false;
    @ConfigurationItemProperty(description="Set File Serving enabled to WAR")
    private WasFileServing fileServing = WasFileServing.DO_NOT_OVERRIDE;

    public WasWarMapping() {
        this.webservers = Collections.EMPTY_SET;
        this.sharedLibraries = Collections.EMPTY_SET;
    }

    public WasWarMapping(War source, WasTarget target, String virtualHost, String contextRoot) {
        this(source, target, Collections.EMPTY_SET, Collections.EMPTY_SET, virtualHost, contextRoot);
    }

    public WasWarMapping(War source, WasTarget target, Set<WasManagedApacheHttpdServer> webservers, Set<WasSharedLibrary> sharedLibraries, String virtualHost, String contextRoot) {
        super(source, (Serializable)target, virtualHost, contextRoot);
        this.webservers = webservers;
        this.sharedLibraries = sharedLibraries;
    }

    public void postInit(Deployment deployment) {
        this.securityRoleUserGroupMappings = WasWarUtils.getSecurityRoleUserGroupMappings(this.getSource());
        super.postInit(deployment);
    }

    public War getSource() {
        War war = (War)super.getSource();
        if (!this.suffixArtifactNameWithTarget) {
            return war;
        }
        War warWithSuffixedName = new War();
        warWithSuffixedName.setLabel(war.getLabel());
        warWithSuffixedName.setLocation(war.getLocation());
        warWithSuffixedName.setName(WebSphereNameBuilder.getDeployedApplicationName(war, this));
        return warWithSuffixedName;
    }

    public Set<WasManagedApacheHttpdServer> getWebservers() {
        return this.webservers;
    }

    public void setWebservers(Set<WasManagedApacheHttpdServer> webservers) {
        this.webservers = webservers;
    }

    public int getStartingWeight() {
        return this.startingWeight;
    }

    public void setStartingWeight(int startingWeight) {
        this.startingWeight = startingWeight;
    }

    public Set<WasSharedLibrary> getSharedLibraries() {
        return this.sharedLibraries;
    }

    public void setSharedLibraries(Set<WasSharedLibrary> sharedLibraries) {
        this.sharedLibraries = sharedLibraries;
    }

    public List<SecurityRoleUserGroupMappings> getSecurityRoleUserGroupMappings() {
        return this.securityRoleUserGroupMappings;
    }

    public void setSecurityRoleUserGroupMappings(List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappings) {
        this.securityRoleUserGroupMappings = securityRoleUserGroupMappings;
    }

    public WasClassLoaderMode getClassLoaderMode() {
        return this.classLoaderMode;
    }

    public void setClassLoaderMode(WasClassLoaderMode classLoaderMode) {
        this.classLoaderMode = classLoaderMode;
    }

    public boolean isSuffixArtifactNameWithTarget() {
        return this.suffixArtifactNameWithTarget;
    }

    public void setSuffixArtifactNameWithTarget(boolean suffixArtifactNameWithTarget) {
        this.suffixArtifactNameWithTarget = suffixArtifactNameWithTarget;
    }

    public WasFileServing getFileServing() {
        return this.fileServing;
    }

    public void setFileServing(WasFileServing fileServing) {
        this.fileServing = fileServing;
    }
}

