/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.ci;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.collections.Transformer;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;

/**
 * A cluster in a {@link WlsDomain WLS domain}.
 * 
 * @see WlsServer
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A WebLogic Cluster, a member of WebLogic Domain. It can have WebLogicServers as it's members", expandable = true, category = "middleware")
public class WlsCluster extends BaseConfigurationItem {
	
	public static final Transformer TOSTRING_FROM_NAME = new Transformer() {
		public String transform(Object obj) {
			return ((WlsCluster) obj).getName();
		}
	};

	@ConfigurationItemProperty(required = true, description = "Name of the WebLogic Cluster", identifying = true)
	private String name = "";

	@ConfigurationItemProperty(required = true, description = "The domain to which the WebLogic Cluster belongs")
	private WlsDomain domain;

	@ConfigurationItemProperty(description = "Servers in the WebLogic Cluster")
	private Set<WlsServer> servers = new HashSet<WlsServer>();

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public WlsDomain getDomain() {
		return domain;
	}

	public void setDomain(WlsDomain domain) {
		this.domain = domain;
	}

	public Set<WlsServer> getServers() {
		return Collections.unmodifiableSet(servers);
	}

	public void setServers(Set<WlsServer> servers) {
		this.servers = servers;
	}

	public Host getHost() {
		return getDomain().getActiveHost();
	}
}
