/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.ci;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.apache.commons.beanutils.BeanComparator;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.ci.Host;

/**
 * A WLS server (Managed or admin) in a {@link WlsDomain WLS domain}.
 * 
 * @see WlsCluster
 * @see WlsDomain
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A standard Weblogic Server")
public class WlsServer extends BaseConfigurationItem {

	@ConfigurationItemProperty(required = true, description = "Name of the WebLogic Server")
	private String name;

	@ConfigurationItemProperty(required = true, description = "Port for the WebLogic Server")
	private int port;

	@ConfigurationItemProperty(description = "Classpath entries for this deployment.")
	private String classpath;

	@ConfigurationItemProperty(description = "Boot classpath entries for this deployment.")
	private String bootClasspath;

	@ConfigurationItemProperty(description = "Initial heap size to be allocated to the JVM (in megabytes).")
	private int initHeapSize;

	@ConfigurationItemProperty(description = "Maximum heap size to be allocated to the JVM (in megabytes).")
	private int maxHeapSize;

	@ConfigurationItemProperty(description = "The arguments to use when starting this server.", size = Size.LARGE)
	private String arguments;

	@ConfigurationItemProperty(description = "Absolute path of log file. Example; /opt/bea/user_projects/domain/managedserver1/ms1.log")
	private String logFileLocation;

	@ConfigurationItemProperty(description = "Enable JVM StdOut to Server Log file")
	private boolean enableJVMLogRedirection = false;

	@ConfigurationItemProperty(required = true, description = "WebLogic Domain to which this server belongs")
	private WlsDomain domain;

	@ConfigurationItemProperty(required = true, description = "Host on which this server is running")
	private Host host;

	@SuppressWarnings("unchecked")
	public static List<WlsServer> toNameSortedList(Set<WlsServer> servers) {
		List<WlsServer> nameSortedServers = new ArrayList<WlsServer>(servers);
		Collections.sort(nameSortedServers, new BeanComparator("name"));
		return nameSortedServers;
	}

	public WlsDomain getDomain() {
		return domain;
	}

	public void setDomain(WlsDomain domain) {
		this.domain = domain;
	}

	public Host getHost() {
		return host;
	}

	public void setHost(Host host) {
		this.host = host;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getClasspath() {
		return classpath;
	}

	public void setClasspath(String classpath) {
		this.classpath = classpath;
	}

	public String getBootClasspath() {
		return bootClasspath;
	}

	public void setBootClasspath(String bootClasspath) {
		this.bootClasspath = bootClasspath;
	}

	public int getInitHeapSize() {
		return initHeapSize;
	}

	public void setInitHeapSize(int initHeapSize) {
		this.initHeapSize = initHeapSize;
	}

	public int getMaxHeapSize() {
		return maxHeapSize;
	}

	public void setMaxHeapSize(int maxHeapSize) {
		this.maxHeapSize = maxHeapSize;
	}

	public String getLogFileLocation() {
		return logFileLocation;
	}

	public void setLogFileLocation(String logFileLocation) {
		this.logFileLocation = logFileLocation;
	}

	public boolean isEnableJVMLogRedirection() {
		return enableJVMLogRedirection;
	}

	public void setEnableJVMLogRedirection(boolean enableJVMLogRedirection) {
		this.enableJVMLogRedirection = enableJVMLogRedirection;
	}

	public String getArguments() {
		return arguments;
	}

	public void setArguments(String arguments) {
		this.arguments = arguments;
	}

}
