/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.wls.WlsConventions;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Creates a {@link WlsJmsModule JMS module}.
 */
@SuppressWarnings("serial")
public class CreateWlsJmsModuleStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-jms-module.py";

	public CreateWlsJmsModuleStep(WlsCluster cluster, WlsJmsModule module) {
		super("Create JMS Module " + module + " for cluster " + cluster + " in domain " + cluster.getDomain(), cluster.getDomain(), SCRIPT_RESOURCE_PATH,
				getArgs(module, cluster));
	}

	private static String[] getArgs(WlsJmsModule module, WlsCluster cluster) {
		List<String> args = new ArrayList<String>();
		args.add(module.getName());
		String jmsServerPrefix = createJMServerPrefix(module.getName());
		args.add(cluster.getName());

		/*
		 * XXX: Why a method that has only one line? Collections.sort(servers, new BeanComparator("name") says exactly the same thing.
		 */
		List<WlsServer> sortedServers = WlsServer.toNameSortedList(cluster.getServers());
		for (int i = 0; i < sortedServers.size(); i++) {
			WlsServer server = sortedServers.get(i);
			int jmsServerIndex = i + 1;
			String jmsServerName = jmsServerPrefix + "-JMSServer_" + jmsServerIndex;
			String jmsFileStoreName = jmsServerPrefix + "-JMSFileStore_" + jmsServerIndex;
			args.add(server.getName());
			args.add(jmsServerName);
			args.add(jmsFileStoreName);
			args.add(WlsConventions.getFilestorePath(cluster.getDomain()));
			args.add(jmsServerName + "-subdeployment");

		}
		return args.toArray(new String[args.size()]);
	}

	protected static String createJMServerPrefix(String moduleName) {
		return StringUtils.remove(moduleName, "-JMSModule");
	}

}
