#
# Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
#
# Your use of Xebialabs Software and Documentation is subject to the Personal
# License Agreement.
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the Xebialabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to  (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys
import os
import time as ptime

sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

name = sys.argv.pop(0)
domain = sys.argv.pop(0)
# Could be a comma separated list of servers or clusters
targetName = sys.argv.pop(0)
maximumThreadConstraintName = sys.argv.pop(0)

#=========================#
# Create WorkManager      #
#=========================#
def createWorkManager(name, domain, targetName, maximumThreadConstraintName):
  log("Creating work manager : " + name + " on domain " + domain)
  targetArray = getClusterServerTargetArray(targetName)
  cd('/SelfTuning/' + domain + '/WorkManagers')
  cmo.createWorkManager(name)
  cd('/SelfTuning/' + domain + '/WorkManagers/' + name)
  set('Targets', targetArray)
  if maximumThreadConstraintName != None:
     cmo.setMaxThreadsConstraint(getMBean('/SelfTuning/' + domainName + '/MaxThreadsConstraints/' + maximumThreadConstraintName))
  return
  
#=====================================#
# Get ClustServer Target Array        #
#=====================================#
def getClusterServerTargetArray(targetlist):
    objectArray=[];
    targets=targetlist.split( "," )
    for target in targets:
        bean=getMBean( '/Servers/'+target )
        if bean != None :
            objectArray.append( ObjectName('com.bea:Name=' + bean.getName() + ',Type='+bean.getType()) )
        bean=getMBean( '/Clusters/'+target )
        if bean != None :
            objectArray.append( ObjectName('com.bea:Name=' + bean.getName() + ',Type='+bean.getType()) )
    if objectArray :
        targetArray = jarray.array(objectArray, ObjectName)
    else :
        raise ValueError('Not targets found for '+targetlist )             
    return targetArray

#==============================#
# Logging method               #
#==============================#
def log(msg, level="info"):
    print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
    return
    
    
#==============================#
# Entry Point                  #
#==============================#
connect(user, password, url)
edit()
startEdit()
createWorkManager(name, domain, targetName, maximumThreadConstraintName)
save()
disconnect('true')
exit('y')
