#
# Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
#
# Your use of Xebialabs Software and Documentation is subject to the Personal
# License Agreement.
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the Xebialabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to  (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys
import os
import time as ptime

ignore = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

modulename = sys.argv.pop(0)
queuename = sys.argv.pop(0)
servername = sys.argv.pop(0)

connect(user, password, url)

def log(msg, level="info"):
    print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
    return

def errlog(msg, level="error"):
    print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
    return

log("Trying to delete queue " + queuename + " in module: " + modulename + " on server: " + servername)
cd ('domainRuntime:/ServerRuntimes/'+servername+'/JMSRuntime/'+servername+'.jms/JMSServers/' + modulename + '-JMSServer_1/Destinations/'+modulename+'!' + queuename)
currentNumberOfMessages = cmo.getMessagesCurrentCount()
if (currentNumberOfMessages != 0):
    errlog("The queue is not empty. It contains " + str(currentNumberOfMessages) + " messages and can not be destroyed")
    sys.exit(1)

cd ('serverConfig:/')
edit()
startEdit()

cd('/JMSSystemResources/' + modulename + '/Resource/' + modulename + '/Queues')
cmo.destroyQueue(getMBean(queuename))

save()
disconnect('true')
exit('y')
