/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * Configuration for the <a href="http://download.oracle.com/docs/cd/E11035_01/wls100/plugins/apache.html">
 * Apache WebLogic plugin</a> in situations where the target environment contains
 * Apache web servers which &quot;front&quot; WLS servers.
 * <p>
 * Supports redirection by MIME match expressions and by target paths.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "An abstraction of Apache Weblogic Plugin Configuration. It is used to generate the configuration file which is included in the Apache main httpd.conf file", category = "middleware")
public class ApacheHttpdWlsPluginConfiguration extends BaseConfigurationItem {

	@ConfigurationItemProperty(description = "Comma separated list of match expression to proxy requests by MIME type")
	private String mimeMatchExpressions;

	@ConfigurationItemProperty(description = "Error Page")
	private String errorPage;

	@ConfigurationItemProperty(description = "Comma separated list of path to be used for proxing requests by path")
	private String pathExpressions;

	public String getMimeMatchExpressions() {
		return mimeMatchExpressions;
	}

	public void setMimeMatchExpressions(String mimeMatchExpressions) {
		this.mimeMatchExpressions = mimeMatchExpressions;
	}

	public String getErrorPage() {
		return errorPage;
	}

	public void setErrorPage(String errorPage) {
		this.errorPage = errorPage;
	}

	public String getPathExpressions() {
		return pathExpressions;
	}

	public void setPathExpressions(String pathExpressions) {
		this.pathExpressions = pathExpressions;
	}

}
