/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A reference to a JMS destination on a {@link WlsForeignJmsServer foreign JMS server}.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A foreign destination (topic or queue) is a destination on a remote server. When this destination is looked up on the local server, a look-up will be performed automatically on the remote JNDI directory, and the object will be returned from that directory")
public class WlsForeignJmsDestination extends WlsResource {

	@ConfigurationItemProperty(description = "The name of the Foreign JMS Server", required = true)
	private WlsForeignJmsServer foreignJmsServer;

	@ConfigurationItemProperty(description = "The name of this foreign destination", required = true, identifying = true)
	private String name;

	@ConfigurationItemProperty(description = "The name that the remote object will be bound to in the local server's JNDI tree", required = true)
	private String localJndiName;

	@ConfigurationItemProperty(description = "The name of the remote object that will be looked up in the remote JNDI directory", required = true)
	private String remoteJndiName;

	public WlsForeignJmsServer getForeignJmsServer() {
		return foreignJmsServer;
	}

	public void setForeignJmsServer(WlsForeignJmsServer foreignJmsServer) {
		this.foreignJmsServer = foreignJmsServer;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getLocalJndiName() {
		return localJndiName;
	}

	public void setLocalJndiName(String localJndiName) {
		this.localJndiName = localJndiName;
	}

	public String getRemoteJndiName() {
		return remoteJndiName;
	}

	public void setRemoteJndiName(String remoteJNDIName) {
		this.remoteJndiName = remoteJNDIName;
	}

}
