package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsServerStep;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsSubdeploymentStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsJmsServerStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsSubdeploymentStep;

public class WlsJmsServerToWlsServerMapper extends MappingAgnosticStepGeneratingMapper<WlsJmsServer, WlsServer> {

	public WlsJmsServerToWlsServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsJmsServer jmsServer, WlsServer server, List<Step> steps) {
		steps.add(new CreateWlsJmsServerStep(server, jmsServer));
		steps.add(new CreateWlsSubdeploymentStep(server.getDomain(), JmsMapperUtils.getJmsModuleName(change, server), jmsServer));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsJmsServer jmsServer, WlsServer server, List<Step> steps) {
		steps.add(new DestroyWlsSubdeploymentStep(server.getDomain(), JmsMapperUtils.getJmsModuleName(change, server), jmsServer));
		steps.add(new DestroyWlsJmsServerStep(server.getDomain(), jmsServer));
	}

}
