#
# Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to  (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys
import os
import time as ptime

scriptname = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)
targetObjectName = sys.argv.pop(0)
name = sys.argv.pop(0)
jndiName = sys.argv.pop(0)
uri = sys.argv.pop(0)
dbUser = sys.argv.pop(0)
dbPassword = sys.argv.pop(0)
driver = sys.argv.pop(0)
initialCapacity = sys.argv.pop(0)
maxCapacity = sys.argv.pop(0)
properties = sys.argv.pop(0)

print "Connecting to WebLogic"
connect(user, password, url)
edit()
startEdit()

print "Creating JDBC resource " + name
cd("/")
cmo.createJDBCSystemResource(name)

cd("/JDBCSystemResources/" + name + "/JDBCResource/"+ name)
set('Name', name)

cd("/JDBCSystemResources/" + name)
set('Targets', jarray.array([ObjectName(targetObjectName)], ObjectName) )

cd("/JDBCSystemResources/" + name + "/JDBCResource/"+ name +"/JDBCDataSourceParams/" + name)
set('JNDINames',jarray.array([String(jndiName)], String))
set('GlobalTransactionsProtocol', 'TwoPhaseCommit')

cd("/JDBCSystemResources/" + name + "/JDBCResource/"+ name +"/JDBCDriverParams/" + name)
set("Url", uri)
set("DriverName", driver)
#set('PasswordEncrypted', dbPassword)
set('Password', dbPassword)

cd("/JDBCSystemResources/" + name + "/JDBCResource/"+ name +"/JDBCConnectionPoolParams/" + name)
set("InitialCapacity", initialCapacity)
set("MaxCapacity", maxCapacity)
set("TestTableName", "SQL SELECT 1 FROM DUAL")
cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCConnectionPoolParams/" + name )
set('TestConnectionsOnReserve', 'true')

cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCDriverParams/" + name + "/Properties/" + name)
cmo.createProperty('user')
cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCDriverParams/" + name + "/Properties/" + name + "/Properties/user")
set("Value", dbUser)
for prop in properties.split(","):
  if(len(prop.split("=")) == 2):
    key=prop.split("=")[0]
    val=prop.split("=")[1]
    cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCDriverParams/" + name + "/Properties/" + name)
    cmo.createProperty(key)
    cd("/JDBCSystemResources/" + name + "/JDBCResource/" + name + "/JDBCDriverParams/" + name + "/Properties/" + name + "/Properties/"+key)
    set("Value", val)

print "Saving configuration"
save()
disconnect('true')
exit('y')

