#
# Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to  (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys
from java.io import File
from java.io import FileOutputStream
from java.util import Collections
from com.bea.wli.config import Ref


def exportAll():
    try:
        
        sys.argv.pop(0)
    
        user = sys.argv.pop(0)
        password = sys.argv.pop(0)
        url = sys.argv.pop(0)
        project = sys.argv.pop(0)
        jarFileName = sys.argv.pop(0)
        
        connectToServer(user, password, url)
        print 'connected'

        ALSBConfigurationMBean = findService("ALSBConfiguration", "com.bea.wli.sb.management.configuration.ALSBConfigurationMBean")
        print "ALSBConfiguration MBean found"

        print project
        if project == None :
            ref = Ref.DOMAIN
            collection = Collections.singleton(ref)
            print "Export the config"
            theBytes = ALSBConfigurationMBean.export(collection, true, None)
        else :
            ref = Ref.makeProjectRef(project);
            print "Export the project", project
            collection = Collections.singleton(ref)
            theBytes = ALSBConfigurationMBean.exportProjects(collection, None)
            
        print 'fileName',jarFileName
        aFile = File(jarFileName)
        print 'file',aFile
        out = FileOutputStream(aFile)
        out.write(theBytes)
        out.close()
        print "ALSB Configuration file: "+ jarFileName + " has been exported"

    except:
        raise
        
#=======================================================================================
# Connect to the Admin Server
#=======================================================================================

def connectToServer(username, password, url):
    connect(username, password, url)
    domainRuntime()



# EXPORT script init
try:
    exportAll()

except:
    print "Unexpected error: ", sys.exc_info()[0]
    dumpStack()
    disconnect()
    exit()
    raise

disconnect()
exit()
