package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A reference to a JMS server outside the current {@link WlsDomain WLS domain}.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "WebLogic foreign server representing a JNDI provider that resides outside a WebLogic Server.")
public class WlsForeignJmsServer extends BaseConfigurationItem {

	@ConfigurationItemProperty(description = "The name of the foreign server", required = true)
	private String name;

	@ConfigurationItemProperty(description = "The initial context of the foreign connection", required = true)
	private String initContextFactory;

	@ConfigurationItemProperty(description = "The URL that WebLogic Server will use to contact the JNDI provider", required = true)
	private String connectionURL;

	@ConfigurationItemProperty(description = "The JMS module the foreign server should be included in.", required = true)
	private WlsJmsModule parentModule;


	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getInitContextFactory() {
		return initContextFactory;
	}

	public void setInitContextFactory(String initContextFactory) {
		this.initContextFactory = initContextFactory;
	}

	public String getConnectionURL() {
		return connectionURL;
	}

	public void setConnectionURL(String connectionURL) {
		this.connectionURL = connectionURL;
	}

	public WlsJmsModule getParentModule() {
		return parentModule;
	}

	public void setParentModule(WlsJmsModule parentModule) {
		this.parentModule = parentModule;
	}

}
