package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A JMS server defined in a {@link WlsDomain WLS domain}.
 * <p>
 * JMS servers should be associated with a {@link WlsServer Managed Server}
 * or Migratable Target in the domain.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "WebLogic JMSServer that can run on a WebLogic Server.")
public class WlsJmsServer extends BaseConfigurationItem {
	
	@ConfigurationItemProperty(description = "Name of the JMSServer. e.g. JMSServer1", required = true)
	private String name;
	
	@ConfigurationItemProperty(description = "Path to the file store that the JMSServer will use to store JMS messages. e.g. /var/jms/store1", required = true)
	private String fileStorePath;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getFileStorePath() {
		return fileStorePath;
	}

	public void setFileStorePath(String fileStorePath) {
		this.fileStorePath = fileStorePath;
	}

}