package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.step.StartApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.StopApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsUndeployArtifactStep;

public class EarToWlsClusterMapper extends Mapper<Ear, EarMapping, WlsCluster> {

	public EarToWlsClusterMapper(Change<Deployment> c) {
		super(c);
	}

	public void generateUndeploySteps(List<Step> steps) {
		for (EarMapping m : getDeletedMappings()) {
			steps.add(new StopApplicationStep((WlsCluster) m.getTarget(), (Ear) m.getSource()));
			steps.add(new WlsUndeployArtifactStep((WlsCluster) m.getTarget(), (Ear) m.getSource()));
		}
		for (Pair<EarMapping, EarMapping> mPair : getModifiedMappings()) {
			steps.add(new StopApplicationStep((WlsCluster) mPair.getFirst().getTarget(), (Ear) mPair.getFirst().getSource()));
			steps.add(new WlsUndeployArtifactStep((WlsCluster) mPair.getFirst().getTarget(), (Ear) mPair.getFirst().getSource()));
		}
	}

	public void generateDeploySteps(List<Step> steps) {
		for (Pair<EarMapping, EarMapping> mPair : getModifiedMappings()) {
			steps.add(new WlsDeployArtifactStep((WlsCluster) mPair.getSecond().getTarget(), (Ear) mPair.getSecond().getSource()));
		}
		for (EarMapping m : getAddedMappings()) {
			steps.add(new WlsDeployArtifactStep((WlsCluster) m.getTarget(), (Ear) m.getSource()));
		}
	}

	public void generateStartSteps(List<Step> steps) {
		for (Pair<EarMapping, EarMapping> mPair : getModifiedMappings()) {
			steps.add(new StartApplicationStep((WlsCluster) mPair.getSecond().getTarget(), (Ear) mPair.getSecond().getSource()));
		}
		for (EarMapping m : getAddedMappings()) {
			steps.add(new StartApplicationStep((WlsCluster) m.getTarget(), (Ear) m.getSource()));
		}
	}

}
