package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDataSource;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsDataSourceStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsDataSourceStep;

public class WlsDataSourceToWlsClusterMapper extends MappingAgnosticStepGeneratingMapper<WlsDataSource, WlsCluster> {

	public WlsDataSourceToWlsClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsDataSource newSource, WlsCluster newTarget, List<Step> steps) {
		steps.add(new CreateWlsDataSourceStep(newTarget, newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsDataSource oldSource, WlsCluster oldTarget, List<Step> steps) {
		steps.add(new DestroyWlsDataSourceStep(oldTarget, oldSource));
	}

}
