package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsForeignJmsDestination;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsForeignJmsDestinationStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsForeignJmsDestinationStep;

public class WlsForeignDestinationToWlsClusterMapper extends MappingAgnosticStepGeneratingMapper<WlsForeignJmsDestination, WlsCluster> {

	public WlsForeignDestinationToWlsClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsForeignJmsDestination newSource, WlsCluster newTarget, List<Step> steps) {
		steps.add(new CreateWlsForeignJmsDestinationStep(newTarget.getDomain(), newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsForeignJmsDestination oldSource, WlsCluster oldTarget, List<Step> steps) {
		steps.add(new DestroyWlsForeignJmsDestinationStep(oldTarget.getDomain(), oldSource));
	}

}
