package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsConnectionFactory;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsConnectionFactoryStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsJmsConnectionFactoryStep;

public class WlsJmsConnectionFactoryToWlsClusterMapper extends MappingAgnosticStepGeneratingMapper<WlsJmsConnectionFactory, WlsCluster> {

	public WlsJmsConnectionFactoryToWlsClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsJmsConnectionFactory newSource, WlsCluster newTarget, List<Step> steps) {
		steps.add(new CreateWlsJmsConnectionFactoryStep(newTarget.getDomain(), newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsJmsConnectionFactory oldSource, WlsCluster oldTarget, List<Step> steps) {
		steps.add(new DestroyWlsJmsConnectionFactoryStep(oldTarget.getDomain(), oldSource));
	}

}
