package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.ModificationSupportingMappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsQueueStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsJmsQueueStep;
import com.xebialabs.deployit.plugin.wls.step.ModifyWlsJmsQueueStep;

public class WlsJmsQueueToWlsServerMapper extends ModificationSupportingMappingAgnosticStepGeneratingMapper<WlsJmsQueue, WlsServer> {

	public WlsJmsQueueToWlsServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsJmsQueue newSource, WlsServer newTarget, List<Step> steps) {
		steps.add(new CreateWlsJmsQueueStep(newTarget, newSource));
	}

	@Override
	protected void generateModificationStepsForModifiedMapping(WlsJmsQueue oldSource, WlsServer oldTarget, WlsJmsQueue newSource, WlsServer newTarget,
			List<Step> steps) {
		steps.add(new ModifyWlsJmsQueueStep(newTarget, oldSource, newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsJmsQueue oldSource, WlsServer oldTarget, List<Step> steps) {
		steps.add(new DestroyWlsJmsQueueStep(oldTarget, oldSource));
	}

}
