package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueueSet;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsQueueSetStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsJmsQueueSetStep;

public class WlsQueueSetToWlsClusterMapper extends MappingAgnosticStepGeneratingMapper<WlsJmsQueueSet, WlsCluster> {

	public WlsQueueSetToWlsClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsJmsQueueSet newSource, WlsCluster newTarget, List<Step> steps) {
		WlsDomain domain = newTarget.getDomain();
		steps.add(new CreateWlsJmsQueueSetStep(domain.getActiveHost(), domain, newSource.getParentModule(), newSource, newTarget.getServers()));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsJmsQueueSet oldSource, WlsCluster oldTarget, List<Step> steps) {
		WlsDomain domain = oldTarget.getDomain();
		steps.add(new DestroyWlsJmsQueueSetStep(domain.getActiveHost(), domain, oldSource.getParentModule(), oldSource, oldTarget.getServers()));
	}

}
